//
//  PPContactRowObject.h
//
//  Created by Howard.Lin on 13/9/27.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPContactLabelTextDefine.h"
#import "PPContactLabelTypeDefine.h"
#import "PPContactMainTypeDefine.h"
#import "PPContactSubTypeDefine.h"
#import "PPContactTableViewCellStyleDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPContactRowObject : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   UITableViewCellEditingStyle  editingStyle;
@property (nonatomic,readonly) NSMutableDictionary          *imageRectDictionary;
@property (nonatomic,readonly) NSMutableDictionary          *inputValueDictionary;
@property (nonatomic,assign)   PPContactTableViewCellStyle  tableViewCellStyle;
@property (nonatomic,assign)   PPContactLabelType           contactLabelType;
@property (nonatomic,assign)   PPContactMainType            contactMainType;
@property (nonatomic,assign)   BOOL                         selected;




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instace Method

/**
 * To check inputValueDictionaryKey if it has a valid value.
 * @return: The inputValieDictionaryKey has a valid value
 */
- (BOOL)checkInputValueDictionaryKeyHasValidValue;


/**
 * To sort inputValueDictionary key
 */
- (NSArray *)sortAllKeys;


/**
 * To get a placeholder for contactMainType
 * @return: The placeholder
 */
- (NSString *)localizedPlaceholder;


/**
 *  取得 placeholder
 *
 *  @param contactSubType subtype 型態
 *  @param countryCode    國別碼(地址欄位會參考)
 *
 *  @return placeholder
 */
- (NSString *)placeholderForPPContactSubType:(PPContactSubType)contactSubType countryCode:(NSString *)countryCode;


/**
 * To get visible field number
 * @return: validVisbleFieldNumber
 */
- (NSUInteger)validVisbleFieldNumberWithCountPhonetic:(BOOL)enablePhonetic;


/**
 * To get PPContactSubType according to the title
 * @param placeholder localized placeholder string
 * @return: The PPContactSubType is according to the title
 */
- (PPContactSubType)contactSubTypeWithLocalizedPlaceholder:(NSString *)placeholder;


/**
 顯示名稱 by SubType
 
 @return 可顯示名稱 by SubType
 */
- (NSString *)visibleTextFromSubType;



/**
 目前顯示的欄位 subtype

 @return 顯示的欄位 subType
 */
- (PPContactSubType)curEditingSubType;



/**
 隱藏欄位 subType

 @return The array of 隱藏欄位 subType
 */
- (NSArray *)hidenSubTypes;



/**
 資料是否合法

 @return YES, 合法
 */
- (BOOL)checkValueIsLegal;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (NSString *)labelTextFromPPContactLabelType:(PPContactLabelType)ppContactLabelType
                            ppContactMainType:(PPContactMainType)ppContactMainType;


+ (PPContactLabelType)ppContactLabelTypeForPPContactMainType:(PPContactMainType)ppContactMainType
                                                   labelText:(NSString *)labelText;

/**
 * To get a PPContactRowObject object with editingStyle, tableViewCellStyle,and PPContactMainType
 * @param contactMainType PPContactMainType
 * @param contactLabelType PPContactLabelType
 * @param editingStyle UITableViewCellEditingStyle
 * @param tableViewCellStyle PPContactTableViewCellStyle
 * @param selected select
 * @return: The PPContactRowObject object is with editingStyle, tableViewCellStyle,and PPContactMainType
 */
+ (PPContactRowObject *)ppContactRowObjectWithPPContactMainType:(PPContactMainType)contactMainType
                                             ppContactLabelType:(PPContactLabelType)contactLabelType
                                      tableViewCellEditingStyle:(UITableViewCellEditingStyle)editingStyle
                                    ppContactTableViewCellStyle:(PPContactTableViewCellStyle)tableViewCellStyle
                                                       selected:(BOOL)selected;



@end
