//
//  WCSocialSearchFlowController.h
//  Pods
//
//  Created by sanhue on 2015/8/24.
//
//

#import <Foundation/Foundation.h>
#import "WCCardModel.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, WCSocialSearchType)
{
    WCSocialSearchType_None = 0,
    WCSocialSearchType_Facebook,
    WCSocialSearchType_LinkedIn,
    WCSocialSearchType_Twitter,
    WCSocialSearchType_SinaWebo,
};

typedef void(^WCSocialSearchCompletion)(WCSocialSearchType searchType, NSString *content);

////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCSocialSearchFlowController : NSObject

/**
 * 開始Social search 流程
 * @param viewController 從哪個頁面開始做
 * @param cardModel 目前的聯絡人資料
 * @param completion 完成時的通知
 */
+ (void)startFromViewController:(UIViewController *)viewController
                      cardModel:(WCCardModel *)cardModel
                     completion:(WCSocialSearchCompletion)completion;

/// 釋放socialSearchFlowController
+ (void)endOfSocialSearchFlowController;

@end
