//
//  WCReRecognitionSelectViewController.h
//  Pods
//
//  Created by sanhue on 2015/9/6.
//
//

#import "PPViewController.h"
// Model
#import "WCRecogSourceModel.h"
#import "WCCardModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
@class WCReRecognitionSelectViewController;

@protocol WCReRecognitionSelectViewControllerDelegate <NSObject>

@optional

/// 界面結束
- (void)didFinishWithViewController:(WCReRecognitionSelectViewController *)viewController;

/// 取消界面
- (void)didCancelWithViewController:(WCReRecognitionSelectViewController *)viewController;

/// 通知辨識，處理完再回傳
- (void)requestRecognizeWithFrontSourceModel:(WCRecogSourceModel *)frontSourceModel
                             backSourceModel:(WCRecogSourceModel *)backSourceModel;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
// 辨識語系列表由外部傳入

@interface WCReRecognitionSelectViewController : PPViewController

@property (nonatomic, assign) id<WCReRecognitionSelectViewControllerDelegate> delegate;

@property (nonatomic, retain) NSString *alertTitle;  // alert title
@property (nonatomic, retain) NSString *message;     // alert message

@property (nonatomic, assign) BOOL showRecogSideInCell; ///辨識語系是否顯示正反面, default YES

/// array of WCRecogLangModel
@property (nonatomic, retain) NSArray *frontRecogLanguages;

/// array of WCRecogLangModel
@property (nonatomic, retain) NSArray *backRecogLanguages;

@property (nonatomic, retain) UIImage *frontCardImage;
@property (nonatomic, retain) UIImage *backCardImage;

@end
