//
//  WCAlbumFlowControllerDelegate.h
//
//
//  Created by Howard on 2016/1/21.
//
//

#import <Foundation/Foundation.h>

@class WCAlbumFlowController;

@protocol WCAlbumFlowControllerDelegate <NSObject>

/**
 *  流程結束
 *
 *  @param albumFlowController 委託者
 */
- (void)albumFlowControllerDidFinish:(WCAlbumFlowController *)albumFlowController;


@optional

/**
 *  流程結束, 到達上限，需要顯示訂閱介頁
 *
 *  @param albumFlowController 委託者
 */
- (void)albumFlowControllerDidFinishWithSubscribeNow:(WCAlbumFlowController *)albumFlowController;


/**
 *  選取多張辨識圖片
 *  辨識需要時間，先辨識完, AP在自行退開
 *
 *  @param albumFlowController  委託者
 *  @param assetImageDictionary 圖片資源
 *  @param recogLanguageTitle   辨識語系
 *  @param viewContrller        來源視圖
 *
 */
- (void)albumFlowController:(WCAlbumFlowController *)albumFlowController didFinishAssetImageDictionary:(NSMutableDictionary *)assetImageDictionary recogLanguageTitle:(NSString *)recogLanguageTitle fromViewContrller:(UIViewController *)viewContrller;


/**
 *  選取圖片
 *
 *  @param albumFlowController 委託者
 *  @param image               圖片
 */
- (void)albumFlowController:(WCAlbumFlowController *)albumFlowController didFinishSelectImage:(UIImage *)image;

/**
 *  詢問上層是否顯示此訊息
 *
 *  @param error 錯誤
 *
 *  @return YES, Show
 */
- (BOOL)albumFlowRequestShowError:(NSError *)error;


/**
 *  詢問上層有無錯誤標題
 *
 *  @param error 錯誤
 *
 *  @return 標題
 */
- (NSString *)albumFlowRequestTitleWithError:(NSError *)error;


/**
 *  詢問上層有無錯誤的解釋
 *
 *  @param error 錯誤
 *
 *  @return 解釋
 */
- (NSString *)albumFlowRequestMessageWithError:(NSError *)error;


@end
