//
//  WCABPeoplePickerViewController.h
//
//
//  Created by Howard.Lin on 2014/3/26.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import <AddressBook/AddressBook.h>

// Define
#import "PPAppearance.h"
#import "WCDisplayNameDefine.h"

// Controller
#import "PPViewController.h"
#import "PPIndexSectionController.h"

// View
#import "PPButton.h"
#import "PPSectionIndexView.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

@class WCABPeoplePickerViewController;

@protocol WCABPeoplePickerViewControllerDelegate <NSObject>

@required
 - (void)ppABPeoplePickerViewController:(WCABPeoplePickerViewController *)ppABPeoplePickerViewController
                    didSelectCardModels:(NSMutableArray *)cardModels;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCABPeoplePickerViewController : PPViewController <PPAppearance>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<WCABPeoplePickerViewControllerDelegate> delegate;
@property (nonatomic,assign) PPIndexSectionControllerStyle              ppIndexSectionControllerStyle;
@property (nonatomic,assign) WCDisplayNameOrder                         eastDisplayNameOrder;
@property (nonatomic,assign) WCDisplayNameOrder                         westDisplayNameOrder;
@property (nonatomic,retain) NSString                                   *groupID;
@property (nonatomic,retain) NSString                                   *sourceID;

//上方按鈕 Normal state 按鈕文字顏色 (default whiteColor)
@property (nonatomic,retain) UIColor *navigationViewButtonNormalTitleColor PP_APPEARANCE_SELECTOR;

//上方按鈕 Highlighted state 按鈕文字顏色 (default whiteColor)
@property (nonatomic,retain) UIColor *navigationViewButtonHighlightedTitleColor PP_APPEARANCE_SELECTOR;

//上方工具列按鈕，highlighted狀態下的背景顏色
@property (nonatomic,retain) UIColor *navigationViewButtonHighlightedBackgroundColor PP_APPEARANCE_SELECTOR;

//上方工具列按鈕，圖像的edgeInsets
@property (nonatomic,assign) UIEdgeInsets navigationViewButtonImageEdgeInsets PP_APPEARANCE_SELECTOR;

//上方標題
@property (nonatomic,copy) NSString *controllerTitle PP_APPEARANCE_SELECTOR;

//列表視圖分隔線顏色
@property (nonatomic,retain) UIColor *tableViewSeparatorColor PP_APPEARANCE_SELECTOR;

//預設多選
@property (nonatomic,assign) BOOL                              multiSelect;

///設定選取幾筆的字串，預設[@"MLS_MultiSelectCount" localized]，nil，表示不顯示，數字請用%d, 有設定controllerTitle時，會ignore這個值
@property (nonatomic,assign)   NSString *selectedStringFormat;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView;


@end
