//
//  WCABCardModel+CNContact.h
//
//
//  Created by Howard on 2018/1/3.
//

#import "WCABCardModel.h"

// Framework
#import <Contacts/Contacts.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSInteger, WCABDC_ConvertMode)
{
    ConvertMode_None = 0,
    ConvertMode_WC_to_AB,
    ConvertMode_AB_to_WC,
};

//////////////////////////////////////////////////

@interface WCABCardModel (CNContact)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (BOOL)convertType2FieldWithCardModel:(WCABCardModel *)cardModel
                               contact:(CNContact *)contact
                             fieldType:(WC_FieldType)fieldType
                           convertMode:(WCABDC_ConvertMode)convertMode
                     convertFieldCount:(NSMutableDictionary *)convertFieldCount
                                 error:(NSError **)error;


- (BOOL)convertType3FieldWithCardModel:(WCABCardModel *)cardModel
                               contact:(CNContact *)contact
                             fieldType:(WC_FieldType)fieldType
                           convertMode:(WCABDC_ConvertMode)convertMode
                     convertFieldCount:(NSMutableDictionary *)convertFieldCount
                                 error:(NSError **)error;

- (BOOL)convertType4FieldWithCardModel:(WCABCardModel *)cardModel
                               contact:(CNContact *)contact
                             fieldType:(WC_FieldType)fieldType
                           convertMode:(WCABDC_ConvertMode)convertMode
                     convertFieldCount:(NSMutableDictionary *)convertFieldCount
                                 error:(NSError **)error;

- (BOOL)convertType5FieldWithCardModel:(WCABCardModel *)cardModel
                               contact:(CNContact *)contact
                             fieldType:(WC_FieldType)fieldType
                           convertMode:(WCABDC_ConvertMode)convertMode
                     convertFieldCount:(NSMutableDictionary *)convertFieldCount
                                 error:(NSError **)error;

/**
 資料轉換 (WCABCardModel <=> CNContact)

 @param convertMode 轉換方向
 @param cardModel 名片模型
 @param convertFieldCount Exchange 要使用
 @param contact 名片
 @param convertNote 轉換 Note
 */
- (void)convertDataWithMode:(WCABDC_ConvertMode)convertMode
                  cardModel:(WCABCardModel *)cardModel
          convertFieldCount:(NSMutableDictionary *)convertFieldCount
                    contact:(CNContact *)contact
                convertNote:(BOOL)convertNote;

@end
