//
//  PPTextViewTableViewCell.h
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewCell.h"
#import "PPTextView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPTextViewTableViewCell;
@protocol PPTextViewTableViewCellDelegate <NSObject>
@optional
- (BOOL)ppTextViewTableViewCell:(PPTextViewTableViewCell *)textViewTableViewCell shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
- (void)ppTextViewTableViewCellDidBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell;
- (void)ppTextViewTableViewCellDidChange:(PPTextViewTableViewCell *)textViewTableViewCell;
- (void)ppTextViewTableViewCellDidChangeSelection:(PPTextViewTableViewCell *)textViewTableViewCell;
- (void)ppTextViewTableViewCellDidEndEditing:(PPTextViewTableViewCell *)textViewTableViewCell;
- (BOOL)ppTextViewTableViewCellShouldBeginEditing:(PPTextViewTableViewCell *)textViewTableViewCell;
- (BOOL)ppTextViewTableViewCellShouldEndEditing:(PPTextViewTableViewCell *)textViewTableViewCell;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPTextViewTableViewCell : PPTableViewCell <UITextViewDelegate>
{
@protected
    id<PPTextViewTableViewCellDelegate> delegate_;
    PPTextView                          *ppTextView_;
    NSUInteger                          maxLength_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign)     id<PPTextViewTableViewCellDelegate> delegate;
@property(nonatomic,readonly)   PPTextView                          *ppTextView;
@property(nonatomic,assign)     NSUInteger                          maxLength;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

- (void)textViewDidBeginEditing;
- (void)textViewDidChange;
- (void)textViewDidChangeSelection;
- (void)textViewDidEndEditing;
- (BOOL)textViewShouldBeginEditing;
- (BOOL)textViewShouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
- (BOOL)textViewShouldEndEditing;

@end
