//
//  PPStorageFileSelectViewControllerDelegate.h
//  Pods
//
//  Created by Howard on 2015/8/7.
//
//

#import <Foundation/Foundation.h>

// Model
#import "PPStorageFielSelectRowModel.h"

@class PPStorageFileSelectViewController;
@protocol PPStorageFileSelectViewControllerDelegate <NSObject>

@required

/**
 *  空間檔案選擇檔案通知
 *
 *  @param storageFileSelectViewController 委托者
 *  @param selectedFileArray The array of PPStorageFielSelectRowModel
 */
- (void)storageFileSelectViewController:(PPStorageFileSelectViewController *)storageFileSelectViewController
               didSelectedFileArray:(NSArray <PPStorageFielSelectRowModel *> *)selectedFileArray;


@optional

/**
 *  是否顯示此錯誤
 *
 *  @param error 錯誤
 *
 *  @return YES, 顯示
 */
- (BOOL)storageFileSelectViewControllerShouldShowAlertError:(NSError *)error;


/**
 *  詢問ap是否有對此錯誤特別解釋
 *
 *  @param error 錯誤
 *
 *  @return 特別解釋
 */
- (NSString *)storageFileSelectViewControllerRequestMessageWithError:(NSError *)error;


- (void)storageFileSelectViewControllerDidCancel:(PPStorageFileSelectViewController *)storageFileSelectViewController;

- (void)storageFileSelectViewControllerDidDismissBusyView:(PPStorageFileSelectViewController *)storageFileSelectViewController;


- (NSUInteger)storageFileSelectViewControllerRequestCardCountFromFilePath:(NSString *)filePath;

@end
