//
//  PPStorageFileFetch.h
//  
//
//  Created by Howard on 2015/8/4.
//
//

#import <Foundation/Foundation.h>

// Define
#import "PPStorageFileSelectViewController+PrivateParameterDefine.h"
#import "PPStorageFileSelectViewController+ResourceDefine.h"
#import "PPStorageFileFetch+StorageFileFetchDelegate.h"

// Model
#import "PPSectionModel.h"

// Controller
#import "PPCloudController.h"
#import "PPLogController.h"
#import "PPPathController.h"

@interface PPStorageFileFetch : NSObject
<
PPCloudDelegate_Delete,
PPCloudDelegate_LoadMetadata,
PPCloudDelegate_LoadFile
>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property 

@property (nonatomic,assign) id<PPStorageFileFetchDelegate> storageFileFetchDelegate;
@property (nonatomic,copy)   NSString                       *defaultFilePath;
@property (nonatomic,retain) NSArray                        *extensionFileNames;
@property (nonatomic,retain) NSDictionary                   *sectionTitleDictionary;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Inherit method

- (void)deleteLocalFileFromPath:(NSString *)path userInfo:(id)userInfo;

- (void)deleteFileFromPath:(NSString *)path userInfo:(id)userInfo;

- (BOOL)fetchSectinoModels;

- (void)downloadFileWithPath:(NSString *)path fileID:(NSString *)fileID useinfo:(id)userinfo;
@end
