//
//  PPSelectController.h
//
//  Fixed      by howard on 13-12-17.
//  Modified   by Egg on 15-02-16.
//  Modified   by Andrew on 15-04-28.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "PPAppearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
typedef void(^SelectCompletion)(NSString *itemString, NSInteger itemIndex);

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectController Protocol

@class PPSelectController;
@protocol PPSelectControllerDelegate <NSObject>
@optional

/**
 *  是否在選取後隱藏select界面,預設為YES
 *
 *  @param selectController selectController
 *
 *  @return YES if needed to be hidden after selected.
 */
- (BOOL)ppSelectControllerShouldHideAfterSelected:(PPSelectController *)selectController;


/**
 *  取得客制化Cell delegate
 *
 *  @param selectController selectController
 *  @param tableView  TableView
 *  @param indexPath  indexPath
 *  @param itemString 當前 item string
 *
 *  @return 客制化UITableViewCell
 */
- (UITableViewCell *)ppSelectController:(PPSelectController *)selectController tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath itemString:(NSString *)itemString;


/**
 *  通知選取的item所對應的index和String
 *
 *  @param selectController selectController
 *  @param itemIndex        indexPath
 *  @param itemString       選取的Item所對應之字串
 */
- (void)ppSelectController:(PPSelectController *)selectController itemSelectedIndex:(NSInteger)itemIndex withString:(NSString *)itemString;


/**
 *  通知Select界面已關閉
 *
 *  @param selectController selectController
 */
- (void)ppSelectControllerDidDismiss:(PPSelectController *)selectController;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSelectController Interface

@interface PPSelectController : NSObject <PPAppearance>





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Simple Parameter & View Property

@property (nonatomic, assign) id<PPSelectControllerDelegate> delegate;
@property (nonatomic, retain) id                             userInfo;
@property (nonatomic, assign) CGFloat                        customCellHeight; // 預設為0(代表自動換行，並且內部自動幫忙計算純文字高度),若非0(不自動換行，所有Cell皆為此高度)
@property (nonatomic, retain) NSArray                       *sourceItemStringArray;
@property (nonatomic, assign) NSInteger                      selectedIndex; //初始化，selectedIndex為－1時表示沒有選中標誌，selectedIndex大於等於0時表示有選中標誌
@property (nonatomic, assign) NSUInteger                     tag;
@property (nonatomic, retain) UIFont                        *cellFontSize;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Custom Content Table Property

/**
 *  Inset of content tableview in Portrait mode,
 *  note that since tableView will be center aligned, the effect of
 *  inset is equal to (top + bottom) / 2 and (left + right) / 2.
 */
@property (nonatomic, assign) UIEdgeInsets contentTableViewPortraitInset PP_APPEARANCE_SELECTOR;


/**
 *  Inset of content tableview in Landscape mode,
 *  note that since tableView will be center aligned, the effect of
 *  inset is equal to (top + bottom) / 2 and (left + right) / 2.
 */
@property (nonatomic, assign) UIEdgeInsets contentTableViewLandScapeInset PP_APPEARANCE_SELECTOR;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Custome title&Table Methods

/**
 * 設定 contentTableView 上方的 title
 */
@property (nonatomic, retain) NSString *title;


/**
 *  設定 contentTableView 上方的 title文字顏色,預設為blackColor
 */
@property (nonatomic, retain) UIColor *titleColor;


/**
 * 設定 contentTableView 上方的 title height
 */
@property (nonatomic, assign) CGFloat titleHeight;


/**
 * 設定 contentTableView 上方的 title background color, 預設為yellow color
 */
@property (nonatomic, retain) UIColor *titleBackgroundColor;


/**
 * 設定內部清單(contentTable)的背景顏色,預設為黑色＆透明度0.8
 */
@property (nonatomic, retain) UIColor *contentTableBackgroundColor;


/**
 * 設定內部清單cell 的normal state 的文字顏色
 */
@property (nonatomic, retain) UIColor *cellNormalTextColor;


/**
 * 設定內部清單cell 的highlighted state 的文字顏色
 */
@property (nonatomic, retain) UIColor *cellHighlightedTextColor;


/**
 *  設定內部清單cell 的highlighted state 背景顏色
 */
@property (nonatomic, retain) UIColor *cellHighlightedBackgroundColor;


/**
 *  tableview cell 選擇的風格 (預設 UITableViewCellSelectionStyleDefault)
 */
@property (nonatomic, assign) UITableViewCellSelectionStyle tableViewCellSelectionStyle;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Show Methods

/**
 *  Show with reload table data & animation & autoOrientation according to viewController
 *
 *  @param viewController 呼叫並呈現的ViewController
 *  @param animated       呈現是否需要動畫
 */
- (void)showFromViewController:(UIViewController *)viewController animated:(BOOL)animated;


/**
 *  Show with reload table data & animation & autoOrientation according to viewController
 *
 *  @param viewController 呼叫並呈現的ViewController
 *  @param animated       呈現是否需要動畫
 *  @param completeHandler 回傳選取結果
 */
- (void)showFromViewController:(UIViewController *)viewController animated:(BOOL)animated completeHendler:(SelectCompletion)completeHandler;



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - View Status Methods

/**
 *  Visibility of current tableView & content button.
 *
 *  @return YES, if visibile.
 */
- (BOOL)isVisible;


/**
 *  Maximum cell content width
 *
 *  @return max width
 */
- (CGFloat)maxCellContentWidth;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Global Attributes Settings

/**
 *  回傳contentTableView 上方的 title height
 *  @return titleColor
 */
+ (CGFloat)titleHeight;


/**
 *  設定 contentTableView 上方的 title height
 *  @param titleHeight 要設定的高度
 */
+ (void)setTitleHeight:(CGFloat)titleHeight;


/**
 *  回傳contentTableView 上方的 title文字顏色,預設為blackColor
 *  @return titleColor
 */
+ (UIColor *)titleColor;


/**
 *  設定 contentTableView 上方的 title文字顏色,預設為blackColor
 *  @param titleColor 要設定的顏色
 */
+ (void)setTitleColor:(UIColor *)titleColor;


/**
 *  回傳contentTableView 上方的 title background color, 預設為yellow color
 *  @return titleBackgroundColor
 */
+ (UIColor *)titleBackgroundColor;


/**
 *  設定 contentTableView 上方的 title background color, 預設為yellow color
 *  @param titleBackgroundColor 要設定的顏色
 */
+ (void)setTitleBackgroundColor:(UIColor *)titleBackgroundColor;


/**
 *  回傳設定內部清單(contentTable)的背景顏色,預設為黑色＆透明度0.8
 *  @return contentTableBackgroundColor
 */
+ (UIColor *)contentTableBackgroundColor;


/**
 *  設定內部清單(contentTable)的背景顏色,預設為黑色＆透明度0.8
 *  @param contentTableBackgroundColor 要設定的顏色
 */
+ (void)setContentTableBackgroundColor:(UIColor *)contentTableBackgroundColor;


/**
 *  回傳內部清單(contentTable)的背景顏色,預設為黑色＆透明度0.8
 *  @return cellNormalTextColor
 */
+ (UIColor *)cellNormalTextColor;


/**
 *  設定內部清單cell 的normal state 的文字顏色
 *  @param cellNormalTextColor 要設定的顏色
 */
+ (void)setCellNormalTextColor:(UIColor *)cellNormalTextColor;


/**
 *  回傳內部清單cell 的highlighted state 的文字顏色
 *  @return cellHighlightedTextColor
 */
+ (UIColor *)cellHighlightedTextColor;


/**
 *  設定內部清單cell 的highlighted state 的文字顏色
 *  @param cellHighlightedTextColor 要設定的顏色
 */
+ (void)setCellHighlightedTextColor:(UIColor *)cellHighlightedTextColor;


/**
 *  回傳內部清單cell 的highlighted state 背景顏色, default nil
 *  @return cellHighlightedTextColor
 */
+ (UIColor *)cellHighlightedBackgroundColor;


/**
 *  設定內部清單cell 的highlighted state 背景顏色, default nil
 *  @param cellHighlightedBackgroundColor 要設定的顏色
 */
+ (void)setCellHighlightedBackgroundColor:(UIColor *)cellHighlightedBackgroundColor;

@end
