//
//  PPRefreshController.h
//  

#import <UIKit/UIKit.h>
#import "PPActivityIndicatorView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_OPTIONS(NSInteger, PPRefreshControllerInfoPosition)
{
    PPRefreshControllerInfoPosition_Top = 0,
    PPRefreshControllerInfoPosition_Bottom,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@class PPRefreshController;
@protocol PPRefreshControllerDelegate <NSObject>
@optional

/**
 * Info view will appear
 *
 * @param refreshController - PPRefreshController instance
 */
- (void)refreshControllerInfoViewWillAppear:(PPRefreshController *)refreshController;


/**
 * Info view did appear
 *
 * @param refreshController - PPRefreshController instance
 */
- (void)refreshControllerInfoViewDidAppear:(PPRefreshController *)refreshController;

/**
 * Info view will disappear
 *
 * @param refreshController - PPRefreshController instance
 */
- (void)refreshControllerInfoViewWillDisappear:(PPRefreshController *)refreshController;


/**
 * Info view did disappear
 *
 * @param refreshController - PPRefreshController instance
 */
- (void)refreshControllerInfoViewDidDisappear:(PPRefreshController *)refreshController;


@end


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPRefreshController : NSObject

@property (nonatomic, assign) id<PPRefreshControllerDelegate> delegate;

/// Target scroll view to apply refresh mechanism (!! 請在viewDidAppear時設定)
@property (nonatomic, retain) UIScrollView *targetScrollView;

/// Tag for outside use
@property (nonatomic, assign) NSInteger tag;

/// Enable/disable refresh mechanism
@property (nonatomic, assign) BOOL enabled;

/// Can use refresh or not currently (infoView在dock狀態時不可refresh)
@property (nonatomic, readonly) BOOL canRefresh;

/// Minimum height for trigger refresh mechanism, default is 80.
@property (nonatomic, assign) CGFloat triggerHeight;

/// 放開手指滑動時也能觸發 (default is NO.)
@property (nonatomic, assign) BOOL canBeTriggeredWithoutTracking;

/// Refresh background color
@property (nonatomic, retain) UIColor *backgroundColor;

/// Info view that will be docked (沒有指定時會顯示refresh影像)
@property (nonatomic, retain) UIView *infoView;

/// Info view's position (top or bottom, default is top.)
@property (nonatomic, assign) PPRefreshControllerInfoPosition infoPosition;

/// 下拉時顯示位置的垂直偏移 (預設為0)
@property (nonatomic, assign) CGFloat refreshDisplayOffsetY;


/**
 * Show info view manually
 */
- (void)showInfoView;


/**
 * Hide info view manually
 */
- (void)hideInfoView;


/**
 * Initial method
 */
+ (instancetype)refreshControllerWithDelegate:(id<PPRefreshControllerDelegate>)delegate;



@end
