//
//  PPMagnifierView.h
//  
//
//  Created by Mike on 13/5/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//


#if TARGET_OS_IPHONE
#import <UIKit/UIKit.h>
#import "UIView+Appearance.h"
#elif TARGET_OS_MAC
#import <Cocoa/Cocoa.h>
#endif

#import "CrossPlatformDefine.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPMagnifierViewDefaultBorder            2
#define PPMagnifierViewDefaultMagnifyRation		2
#define PPMagnifierViewDefaultRadius			60						//放大鏡的半徑
#define PPMagnifierViewDefaultOffset            CGPointMake(0, -20)		//放大鏡的位移

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPMagnifierViewStyle)
{
	PPMagnifierViewStyle_Default = 0,
	PPMagnifierViewStyle_SelectText,
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPMagnifierView : CPView
{

@private
    PPMagnifierViewStyle	style_;
    CGFloat                 magnifyRatio_;
    CGPoint                 offset_;
    CGPoint                 targetPoint_;
    CPView                  *targetView_;
    
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,assign) PPMagnifierViewStyle	style;
@property(nonatomic,assign) CGFloat                 magnifyRatio;
@property(nonatomic,assign) CGPoint                 offset;
@property(nonatomic,assign) CGPoint                 targetPoint;
@property(nonatomic,retain) CPView                  *targetView;

#if TARGET_OS_IPHONE
@property(nonatomic,retain) CPColor                 *magnifierViewBackgroundColor UI_APPEARANCE_SELECTOR;
#elif TARGET_OS_MAC
@property(nonatomic,assign) BOOL screenMagnifier;
@property(nonatomic,retain) CPColor                 *magnifierViewBackgroundColor;
#endif

@end

////////////////////////////////////////////////////////////////////////////////////////////////////
