//
//  PPKeychainController.h
//  WorldCardMobile
//
//  Created by  Eddie  on 2011/12/19.
//  Fixed   by  Howard on 2013/09/06
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPKeychainControllerStatus)
{
    PPKeychainControllerStatus_Success      = 1,
    PPKeychainControllerStatus_UnknownError = 2,
    PPKeychainControllerStatus_NotFound     = 3
};

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPKeychainController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 * To add Data to systemKeychain
 * @param data   input data
 * @param keyTag    key-value's key
 * @return if return PPKeychainControllerStatus_Success, add data successful
 */
+ (PPKeychainControllerStatus)addData:(NSData *)data withKeyTag:(NSString *)keyTag;


/**
 * To get Data from systemKeychain
 * @param data   point to data which saves in systemkeychain
 * @param keyTag    key-value's key
 * @return if return PPKeychainControllerStatus_Success, get data successful
 */
+ (PPKeychainControllerStatus)getData:(NSData **)data withKeyTag:(NSString *)keyTag;


/**
 * To update Data to systemKeychain
 * @param data   input data
 * @param keyTag    key-value's key
 * @return if return PPKeychainControllerStatus_Success, update data successful
 */
+ (PPKeychainControllerStatus)updateData:(NSData *)data withKeyTag:(NSString *)keyTag;


/**
 * To remove Data to systemKeychain
 * @param keyTag    key-value's key
 * @return if return PPKeychainControllerStatus_Success, remove data successful
 */
+ (PPKeychainControllerStatus)removeKeyTag:(NSString *)keyTag;

@end
