//
//  PPAlbumViewController.h
//
//  Created by howard.lin on 13/3/13.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <Photos/Photos.h>

// Define
#import "PPAlbumDefine.h"
#import "PPAppearance.h"
#import "PPAlbumViewControllerDelegate.h"

// Controller
#import "PPViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlbumViewController

@interface PPAlbumViewController : PPViewController <PPAppearance>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property
@property (nonatomic,assign) id<PPAlbumViewControllerDelegate> delegate;
@property (nonatomic,assign) CGFloat                           tableViewCellRowHeight PP_APPEARANCE_SELECTOR;
@property (nonatomic,retain) UIColor                           *navigationBarViewButtonHighlightedBackgroundColor PP_APPEARANCE_SELECTOR;

@property (nonatomic,assign) UIEdgeInsets navigationBarViewButtonImageEdgeInset PP_APPEARANCE_SELECTOR;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (void)presentFromSuperViewController:(UIViewController *)superViewController
                              delegate:(id<PPAlbumViewControllerDelegate>)delegate
                  mountSanboxDirectory:(NSString *)mountSanboxDirectory;


+ (void)checkAuthenticationWithCompleteHandler:(void(^)(PHAuthorizationStatus status))completeHandler;
@end
