//
//  PPAlbumContentViewController.h
//
//  Created by howard.lin on 13/3/11.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <Photos/Photos.h>

// Define
#import "PPAlbumContentViewControllerDelegate.h"

// View
#import "AlbumContentView.h"
#import "AlbumContentNavigationBarView.h"

// Controller
#import "PPViewController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlbumContentViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPAlbumContentViewController : PPViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<PPAlbumContentViewControllerDelegate> delegate;
@property (nonatomic,readonly) AlbumContentView                       *albumContentView;
@property (nonatomic,readonly) AlbumContentNavigationBarView          *albumContentNavigationBarView;
@property (nonatomic,retain)   UIColor                                *navigationBarViewButtonHighlightedBackgroundColor;
@property (nonatomic,retain)   UIColor                                *tableViewSectionHeaderViewBackgroundColor;
@property (nonatomic,retain)   UIColor                                *tableViewSectionTitleColor;
@property (nonatomic,assign)   BOOL                                   avoidAgainSendResult;
@property (nonatomic,assign)   BOOL                                   multiSelection;
@property (nonatomic,assign)   BOOL                                   allSelect;
@property (nonatomic,assign)   BOOL                                   enableMultiSectionTitle;
@property (nonatomic,assign)   BOOL                                   scrollToEnd;
@property (nonatomic,assign)   UIEdgeInsets                           navigationBarViewButtonImageEdgeInset;

//最大選擇上限
@property (nonatomic,assign)   NSUInteger                             selectedMaximumCount;
@property (nonatomic,retain)   NSString                               *titleString;



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 * To show ppBusyView or no
 * @param show The parameter you have to set to show ppBusyView or no
 * @param superView The superView in which ppBusyView locates. If you set a nil superview, we assume that superView is a rootView.
 */
- (void)showBusyView:(BOOL)show withSuperView:(UIView *)superView;

// 指定app沙箱為其內容
- (void)assignAppSanboxToContentProviderWithFileDirectory:(NSString *)fileDirectory;
// 指定系統相簿為其內容
- (void)assignSytemAlbumToContentProviderWithAssertCollection:(PHAssetCollection *)assetCollection enableMultiSection:(BOOL)enableMultiSection;

@end

