//
//  PP3rdPartyLoginViewController.h
//
//
//  Created by Howard on 2019/6/25.
//

#import "PPViewController.h"

// View
#import "PPButton.h"
#import "PP3rdPartyLoginView.h"
#import "PPNavigationBarView.h"

@interface PP3rdPartyLoginViewController : PPViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, retain) PP3rdPartyLoginView *loginView;
@property (nonatomic,retain) NSString *clientID;
@property (nonatomic,retain) NSString *secretID;
@property (nonatomic,retain) NSString *redirectURL;
@property (nonatomic,copy) AuthCompletion loginCompletion;

@property (nonatomic,retain) NSString *titleString;
@property (nonatomic, retain, readonly) PPButton *ppButtonBack;
@property (nonatomic, retain, readonly) PPNavigationBarView *ppNavigationBarView;

/// 如果是App的進入點，就不能有返回，default NO
@property (nonatomic, assign) BOOL isLaunchPage;



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showAuthWithClientID:(NSString *)clientID
                    secretID:(NSString *)secretID
                 redirectURL:(NSString *)redirectURL
         superViewController:(UIViewController *)superViewController
                  completion:(AuthCompletion)completion;

- (void)showRetryAlertWithError:(NSError *)error;

/// 重load webview
- (void)reloadWebView;

@end
