///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBUSERSUserFeature;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UserFeature` union.
///
/// A set of features that a Dropbox User account may have configured.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBUSERSUserFeature : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBUSERSUserFeatureTag` enum type represents the possible tag states
/// with which the `DBUSERSUserFeature` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBUSERSUserFeatureTag){
    /// This feature contains information about how the user's Paper files are
    /// stored.
    DBUSERSUserFeaturePaperAsFiles,

    /// This feature allows users to lock files in order to restrict other users
    /// from editing them.
    DBUSERSUserFeatureFileLocking,

    /// (no description).
    DBUSERSUserFeatureOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBUSERSUserFeatureTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "paper_as_files".
///
/// Description of the "paper_as_files" tag state: This feature contains
/// information about how the user's Paper files are stored.
///
/// @return An initialized instance.
///
- (instancetype)initWithPaperAsFiles;

///
/// Initializes union class with tag state of "file_locking".
///
/// Description of the "file_locking" tag state: This feature allows users to
/// lock files in order to restrict other users from editing them.
///
/// @return An initialized instance.
///
- (instancetype)initWithFileLocking;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "paper_as_files".
///
/// @return Whether the union's current tag state has value "paper_as_files".
///
- (BOOL)isPaperAsFiles;

///
/// Retrieves whether the union's current tag state has value "file_locking".
///
/// @return Whether the union's current tag state has value "file_locking".
///
- (BOOL)isFileLocking;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBUSERSUserFeature` union.
///
@interface DBUSERSUserFeatureSerializer : NSObject

///
/// Serializes `DBUSERSUserFeature` instances.
///
/// @param instance An instance of the `DBUSERSUserFeature` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBUSERSUserFeature` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBUSERSUserFeature *)instance;

///
/// Deserializes `DBUSERSUserFeature` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBUSERSUserFeature` API object.
///
/// @return An instantiation of the `DBUSERSUserFeature` object.
///
+ (DBUSERSUserFeature *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
