///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBTasks.h"

@class DBCOMMONRootInfo;
@class DBNilObject;
@class DBUSERSBasicAccount;
@class DBUSERSCOMMONAccountType;
@class DBUSERSFullAccount;
@class DBUSERSFullTeam;
@class DBUSERSGetAccountBatchError;
@class DBUSERSGetAccountError;
@class DBUSERSName;
@class DBUSERSSpaceAllocation;
@class DBUSERSSpaceUsage;
@class DBUSERSUserFeature;
@class DBUSERSUserFeatureValue;
@class DBUSERSUserFeaturesGetValuesBatchError;
@class DBUSERSUserFeaturesGetValuesBatchResult;

@protocol DBTransportClient;

///
/// Routes for the `Users` namespace
///

NS_ASSUME_NONNULL_BEGIN

@interface DBUSERSUserAuthRoutes : NSObject

/// An instance of the networking client that each route will use to submit a
/// request.
@property (nonatomic, readonly) id<DBTransportClient> client;

/// Initializes the `DBUSERSUserAuthRoutes` namespace container object with a
/// networking client.
- (instancetype)init:(id<DBTransportClient>)client;

///
/// Get a list of feature values that may be configured for the current account.
///
/// @param features A list of features in UserFeature. If the list is empty, this route will return
/// UserFeaturesGetValuesBatchError.
///
/// @return Through the response callback, the caller will receive a `DBUSERSUserFeaturesGetValuesBatchResult` object on
/// success or a `DBUSERSUserFeaturesGetValuesBatchError` object on failure.
///
- (DBRpcTask<DBUSERSUserFeaturesGetValuesBatchResult *, DBUSERSUserFeaturesGetValuesBatchError *> *)featuresGetValues:
    (NSArray<DBUSERSUserFeature *> *)features;

///
/// Get information about a user's account.
///
/// @param accountId A user's account identifier.
///
/// @return Through the response callback, the caller will receive a `DBUSERSBasicAccount` object on success or a
/// `DBUSERSGetAccountError` object on failure.
///
- (DBRpcTask<DBUSERSBasicAccount *, DBUSERSGetAccountError *> *)getAccount:(NSString *)accountId;

///
/// Get information about multiple user accounts.  At most 300 accounts may be queried per request.
///
/// @param accountIds List of user account identifiers.  Should not contain any duplicate account IDs.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBUSERSBasicAccount *>` object on success
/// or a `DBUSERSGetAccountBatchError` object on failure.
///
- (DBRpcTask<NSArray<DBUSERSBasicAccount *> *, DBUSERSGetAccountBatchError *> *)getAccountBatch:
    (NSArray<NSString *> *)accountIds;

///
/// Get information about the current user's account.
///
///
/// @return Through the response callback, the caller will receive a `DBUSERSFullAccount` object on success or a `void`
/// object on failure.
///
- (DBRpcTask<DBUSERSFullAccount *, DBNilObject *> *)getCurrentAccount;

///
/// Get the space usage information for the current user's account.
///
///
/// @return Through the response callback, the caller will receive a `DBUSERSSpaceUsage` object on success or a `void`
/// object on failure.
///
- (DBRpcTask<DBUSERSSpaceUsage *, DBNilObject *> *)getSpaceUsage;

@end

NS_ASSUME_NONNULL_END
