///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBUSERSIndividualSpaceAllocation;
@class DBUSERSSpaceAllocation;
@class DBUSERSTeamSpaceAllocation;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SpaceAllocation` union.
///
/// Space is allocated differently based on the type of account.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBUSERSSpaceAllocation : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBUSERSSpaceAllocationTag` enum type represents the possible tag states
/// with which the `DBUSERSSpaceAllocation` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBUSERSSpaceAllocationTag){
    /// The user's space allocation applies only to their individual account.
    DBUSERSSpaceAllocationIndividual,

    /// The user shares space with other members of their team.
    DBUSERSSpaceAllocationTeam,

    /// (no description).
    DBUSERSSpaceAllocationOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBUSERSSpaceAllocationTag tag;

/// The user's space allocation applies only to their individual account. @note
/// Ensure the `isIndividual` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly) DBUSERSIndividualSpaceAllocation *individual;

/// The user shares space with other members of their team. @note Ensure the
/// `isTeam` method returns true before accessing, otherwise a runtime exception
/// will be raised.
@property (nonatomic, readonly) DBUSERSTeamSpaceAllocation *team;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "individual".
///
/// Description of the "individual" tag state: The user's space allocation
/// applies only to their individual account.
///
/// @param individual The user's space allocation applies only to their
/// individual account.
///
/// @return An initialized instance.
///
- (instancetype)initWithIndividual:(DBUSERSIndividualSpaceAllocation *)individual;

///
/// Initializes union class with tag state of "team".
///
/// Description of the "team" tag state: The user shares space with other
/// members of their team.
///
/// @param team The user shares space with other members of their team.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeam:(DBUSERSTeamSpaceAllocation *)team;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "individual".
///
/// @note Call this method and ensure it returns true before accessing the
/// `individual` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "individual".
///
- (BOOL)isIndividual;

///
/// Retrieves whether the union's current tag state has value "team".
///
/// @note Call this method and ensure it returns true before accessing the
/// `team` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "team".
///
- (BOOL)isTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBUSERSSpaceAllocation` union.
///
@interface DBUSERSSpaceAllocationSerializer : NSObject

///
/// Serializes `DBUSERSSpaceAllocation` instances.
///
/// @param instance An instance of the `DBUSERSSpaceAllocation` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBUSERSSpaceAllocation` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBUSERSSpaceAllocation *)instance;

///
/// Deserializes `DBUSERSSpaceAllocation` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBUSERSSpaceAllocation` API object.
///
/// @return An instantiation of the `DBUSERSSpaceAllocation` object.
///
+ (DBUSERSSpaceAllocation *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
