///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMUserResendEmailsResult;
@class DBTEAMUserResendResult;
@class DBTEAMUserSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UserResendResult` union.
///
/// Result of trying to resend verification emails to a user. 'success' is the
/// only value indicating that a user was successfully retrieved for sending
/// verification emails. The other values explain the type of error that
/// occurred, and include the user for which the error occured.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMUserResendResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMUserResendResultTag` enum type represents the possible tag states
/// with which the `DBTEAMUserResendResult` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMUserResendResultTag){
    /// Describes a user and the results for each attempt to resend verification
    /// emails.
    DBTEAMUserResendResultSuccess,

    /// Specified user is not a valid target for resending verification emails.
    DBTEAMUserResendResultInvalidUser,

    /// (no description).
    DBTEAMUserResendResultOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMUserResendResultTag tag;

/// Describes a user and the results for each attempt to resend verification
/// emails. @note Ensure the `isSuccess` method returns true before accessing,
/// otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMUserResendEmailsResult *success;

/// Specified user is not a valid target for resending verification emails.
/// @note Ensure the `isInvalidUser` method returns true before accessing,
/// otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMUserSelectorArg *invalidUser;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "success".
///
/// Description of the "success" tag state: Describes a user and the results for
/// each attempt to resend verification emails.
///
/// @param success Describes a user and the results for each attempt to resend
/// verification emails.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuccess:(DBTEAMUserResendEmailsResult *)success;

///
/// Initializes union class with tag state of "invalid_user".
///
/// Description of the "invalid_user" tag state: Specified user is not a valid
/// target for resending verification emails.
///
/// @param invalidUser Specified user is not a valid target for resending
/// verification emails.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidUser:(DBTEAMUserSelectorArg *)invalidUser;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "success".
///
/// @note Call this method and ensure it returns true before accessing the
/// `success` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "success".
///
- (BOOL)isSuccess;

///
/// Retrieves whether the union's current tag state has value "invalid_user".
///
/// @note Call this method and ensure it returns true before accessing the
/// `invalidUser` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "invalid_user".
///
- (BOOL)isInvalidUser;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMUserResendResult` union.
///
@interface DBTEAMUserResendResultSerializer : NSObject

///
/// Serializes `DBTEAMUserResendResult` instances.
///
/// @param instance An instance of the `DBTEAMUserResendResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMUserResendResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMUserResendResult *)instance;

///
/// Deserializes `DBTEAMUserResendResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMUserResendResult` API object.
///
/// @return An instantiation of the `DBTEAMUserResendResult` object.
///
+ (DBTEAMUserResendResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
