///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMTeamFolderListResult;
@class DBTEAMTeamFolderMetadata;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamFolderListResult` struct.
///
/// Result for `teamFolderList` and `teamFolderListContinue`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTeamFolderListResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// List of all team folders in the authenticated team.
@property (nonatomic, readonly) NSArray<DBTEAMTeamFolderMetadata *> *teamFolders;

/// Pass the cursor into `teamFolderListContinue` to obtain additional team
/// folders.
@property (nonatomic, readonly, copy) NSString *cursor;

/// Is true if there are additional team folders that have not been returned
/// yet. An additional call to `teamFolderListContinue` can retrieve them.
@property (nonatomic, readonly) NSNumber *hasMore;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param teamFolders List of all team folders in the authenticated team.
/// @param cursor Pass the cursor into `teamFolderListContinue` to obtain
/// additional team folders.
/// @param hasMore Is true if there are additional team folders that have not
/// been returned yet. An additional call to `teamFolderListContinue` can
/// retrieve them.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamFolders:(NSArray<DBTEAMTeamFolderMetadata *> *)teamFolders
                             cursor:(NSString *)cursor
                            hasMore:(NSNumber *)hasMore;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `TeamFolderListResult` struct.
///
@interface DBTEAMTeamFolderListResultSerializer : NSObject

///
/// Serializes `DBTEAMTeamFolderListResult` instances.
///
/// @param instance An instance of the `DBTEAMTeamFolderListResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderListResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderListResult *)instance;

///
/// Deserializes `DBTEAMTeamFolderListResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderListResult` API object.
///
/// @return An instantiation of the `DBTEAMTeamFolderListResult` object.
///
+ (DBTEAMTeamFolderListResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
