///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSyncSettingsError;
@class DBTEAMTeamFolderCreateError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamFolderCreateError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMTeamFolderCreateError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMTeamFolderCreateErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMTeamFolderCreateError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMTeamFolderCreateErrorTag){
    /// The provided name cannot be used.
    DBTEAMTeamFolderCreateErrorInvalidFolderName,

    /// There is already a team folder with the provided name.
    DBTEAMTeamFolderCreateErrorFolderNameAlreadyUsed,

    /// The provided name cannot be used because it is reserved.
    DBTEAMTeamFolderCreateErrorFolderNameReserved,

    /// An error occurred setting the sync settings.
    DBTEAMTeamFolderCreateErrorSyncSettingsError,

    /// (no description).
    DBTEAMTeamFolderCreateErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMTeamFolderCreateErrorTag tag;

/// An error occurred setting the sync settings. @note Ensure the
/// `isSyncSettingsError` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly) DBFILESSyncSettingsError *syncSettingsError;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "invalid_folder_name".
///
/// Description of the "invalid_folder_name" tag state: The provided name cannot
/// be used.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidFolderName;

///
/// Initializes union class with tag state of "folder_name_already_used".
///
/// Description of the "folder_name_already_used" tag state: There is already a
/// team folder with the provided name.
///
/// @return An initialized instance.
///
- (instancetype)initWithFolderNameAlreadyUsed;

///
/// Initializes union class with tag state of "folder_name_reserved".
///
/// Description of the "folder_name_reserved" tag state: The provided name
/// cannot be used because it is reserved.
///
/// @return An initialized instance.
///
- (instancetype)initWithFolderNameReserved;

///
/// Initializes union class with tag state of "sync_settings_error".
///
/// Description of the "sync_settings_error" tag state: An error occurred
/// setting the sync settings.
///
/// @param syncSettingsError An error occurred setting the sync settings.
///
/// @return An initialized instance.
///
- (instancetype)initWithSyncSettingsError:(DBFILESSyncSettingsError *)syncSettingsError;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "invalid_folder_name".
///
/// @return Whether the union's current tag state has value
/// "invalid_folder_name".
///
- (BOOL)isInvalidFolderName;

///
/// Retrieves whether the union's current tag state has value
/// "folder_name_already_used".
///
/// @return Whether the union's current tag state has value
/// "folder_name_already_used".
///
- (BOOL)isFolderNameAlreadyUsed;

///
/// Retrieves whether the union's current tag state has value
/// "folder_name_reserved".
///
/// @return Whether the union's current tag state has value
/// "folder_name_reserved".
///
- (BOOL)isFolderNameReserved;

///
/// Retrieves whether the union's current tag state has value
/// "sync_settings_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `syncSettingsError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "sync_settings_error".
///
- (BOOL)isSyncSettingsError;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMTeamFolderCreateError` union.
///
@interface DBTEAMTeamFolderCreateErrorSerializer : NSObject

///
/// Serializes `DBTEAMTeamFolderCreateError` instances.
///
/// @param instance An instance of the `DBTEAMTeamFolderCreateError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderCreateError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMTeamFolderCreateError *)instance;

///
/// Deserializes `DBTEAMTeamFolderCreateError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMTeamFolderCreateError` API object.
///
/// @return An instantiation of the `DBTEAMTeamFolderCreateError` object.
///
+ (DBTEAMTeamFolderCreateError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
