///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMMemberAddResult;
@class DBTEAMTeamMemberInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberAddResult` union.
///
/// Describes the result of attempting to add a single user to the team.
/// 'success' is the only value indicating that a user was indeed added to the
/// team - the other values explain the type of failure that occurred, and
/// include the email of the user for which the operation has failed.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMemberAddResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMMemberAddResultTag` enum type represents the possible tag states
/// with which the `DBTEAMMemberAddResult` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMMemberAddResultTag){
    /// Describes a user that was successfully added to the team.
    DBTEAMMemberAddResultSuccess,

    /// Team is already full. The organization has no available licenses.
    DBTEAMMemberAddResultTeamLicenseLimit,

    /// Team is already full. The free team member limit has been reached.
    DBTEAMMemberAddResultFreeTeamMemberLimitReached,

    /// User is already on this team. The provided email address is associated
    /// with a user who is already a member of (including in recoverable state)
    /// or invited to the team.
    DBTEAMMemberAddResultUserAlreadyOnTeam,

    /// User is already on another team. The provided email address is
    /// associated with a user that is already a member or invited to another
    /// team.
    DBTEAMMemberAddResultUserOnAnotherTeam,

    /// User is already paired.
    DBTEAMMemberAddResultUserAlreadyPaired,

    /// User migration has failed.
    DBTEAMMemberAddResultUserMigrationFailed,

    /// A user with the given external member ID already exists on the team
    /// (including in recoverable state).
    DBTEAMMemberAddResultDuplicateExternalMemberId,

    /// A user with the given persistent ID already exists on the team
    /// (including in recoverable state).
    DBTEAMMemberAddResultDuplicateMemberPersistentId,

    /// Persistent ID is only available to teams with persistent ID SAML
    /// configuration. Please contact Dropbox for more information.
    DBTEAMMemberAddResultPersistentIdDisabled,

    /// User creation has failed.
    DBTEAMMemberAddResultUserCreationFailed,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMMemberAddResultTag tag;

/// Describes a user that was successfully added to the team. @note Ensure the
/// `isSuccess` method returns true before accessing, otherwise a runtime
/// exception will be raised.
@property (nonatomic, readonly) DBTEAMTeamMemberInfo *success;

/// Team is already full. The organization has no available licenses. @note
/// Ensure the `isTeamLicenseLimit` method returns true before accessing,
/// otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *teamLicenseLimit;

/// Team is already full. The free team member limit has been reached. @note
/// Ensure the `isFreeTeamMemberLimitReached` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *freeTeamMemberLimitReached;

/// User is already on this team. The provided email address is associated with
/// a user who is already a member of (including in recoverable state) or
/// invited to the team. @note Ensure the `isUserAlreadyOnTeam` method returns
/// true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *userAlreadyOnTeam;

/// User is already on another team. The provided email address is associated
/// with a user that is already a member or invited to another team. @note
/// Ensure the `isUserOnAnotherTeam` method returns true before accessing,
/// otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *userOnAnotherTeam;

/// User is already paired. @note Ensure the `isUserAlreadyPaired` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *userAlreadyPaired;

/// User migration has failed. @note Ensure the `isUserMigrationFailed` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *userMigrationFailed;

/// A user with the given external member ID already exists on the team
/// (including in recoverable state). @note Ensure the
/// `isDuplicateExternalMemberId` method returns true before accessing,
/// otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *duplicateExternalMemberId;

/// A user with the given persistent ID already exists on the team (including in
/// recoverable state). @note Ensure the `isDuplicateMemberPersistentId` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *duplicateMemberPersistentId;

/// Persistent ID is only available to teams with persistent ID SAML
/// configuration. Please contact Dropbox for more information. @note Ensure the
/// `isPersistentIdDisabled` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *persistentIdDisabled;

/// User creation has failed. @note Ensure the `isUserCreationFailed` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *userCreationFailed;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "success".
///
/// Description of the "success" tag state: Describes a user that was
/// successfully added to the team.
///
/// @param success Describes a user that was successfully added to the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithSuccess:(DBTEAMTeamMemberInfo *)success;

///
/// Initializes union class with tag state of "team_license_limit".
///
/// Description of the "team_license_limit" tag state: Team is already full. The
/// organization has no available licenses.
///
/// @param teamLicenseLimit Team is already full. The organization has no
/// available licenses.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamLicenseLimit:(NSString *)teamLicenseLimit;

///
/// Initializes union class with tag state of "free_team_member_limit_reached".
///
/// Description of the "free_team_member_limit_reached" tag state: Team is
/// already full. The free team member limit has been reached.
///
/// @param freeTeamMemberLimitReached Team is already full. The free team member
/// limit has been reached.
///
/// @return An initialized instance.
///
- (instancetype)initWithFreeTeamMemberLimitReached:(NSString *)freeTeamMemberLimitReached;

///
/// Initializes union class with tag state of "user_already_on_team".
///
/// Description of the "user_already_on_team" tag state: User is already on this
/// team. The provided email address is associated with a user who is already a
/// member of (including in recoverable state) or invited to the team.
///
/// @param userAlreadyOnTeam User is already on this team. The provided email
/// address is associated with a user who is already a member of (including in
/// recoverable state) or invited to the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserAlreadyOnTeam:(NSString *)userAlreadyOnTeam;

///
/// Initializes union class with tag state of "user_on_another_team".
///
/// Description of the "user_on_another_team" tag state: User is already on
/// another team. The provided email address is associated with a user that is
/// already a member or invited to another team.
///
/// @param userOnAnotherTeam User is already on another team. The provided email
/// address is associated with a user that is already a member or invited to
/// another team.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserOnAnotherTeam:(NSString *)userOnAnotherTeam;

///
/// Initializes union class with tag state of "user_already_paired".
///
/// Description of the "user_already_paired" tag state: User is already paired.
///
/// @param userAlreadyPaired User is already paired.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserAlreadyPaired:(NSString *)userAlreadyPaired;

///
/// Initializes union class with tag state of "user_migration_failed".
///
/// Description of the "user_migration_failed" tag state: User migration has
/// failed.
///
/// @param userMigrationFailed User migration has failed.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserMigrationFailed:(NSString *)userMigrationFailed;

///
/// Initializes union class with tag state of "duplicate_external_member_id".
///
/// Description of the "duplicate_external_member_id" tag state: A user with the
/// given external member ID already exists on the team (including in
/// recoverable state).
///
/// @param duplicateExternalMemberId A user with the given external member ID
/// already exists on the team (including in recoverable state).
///
/// @return An initialized instance.
///
- (instancetype)initWithDuplicateExternalMemberId:(NSString *)duplicateExternalMemberId;

///
/// Initializes union class with tag state of "duplicate_member_persistent_id".
///
/// Description of the "duplicate_member_persistent_id" tag state: A user with
/// the given persistent ID already exists on the team (including in recoverable
/// state).
///
/// @param duplicateMemberPersistentId A user with the given persistent ID
/// already exists on the team (including in recoverable state).
///
/// @return An initialized instance.
///
- (instancetype)initWithDuplicateMemberPersistentId:(NSString *)duplicateMemberPersistentId;

///
/// Initializes union class with tag state of "persistent_id_disabled".
///
/// Description of the "persistent_id_disabled" tag state: Persistent ID is only
/// available to teams with persistent ID SAML configuration. Please contact
/// Dropbox for more information.
///
/// @param persistentIdDisabled Persistent ID is only available to teams with
/// persistent ID SAML configuration. Please contact Dropbox for more
/// information.
///
/// @return An initialized instance.
///
- (instancetype)initWithPersistentIdDisabled:(NSString *)persistentIdDisabled;

///
/// Initializes union class with tag state of "user_creation_failed".
///
/// Description of the "user_creation_failed" tag state: User creation has
/// failed.
///
/// @param userCreationFailed User creation has failed.
///
/// @return An initialized instance.
///
- (instancetype)initWithUserCreationFailed:(NSString *)userCreationFailed;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "success".
///
/// @note Call this method and ensure it returns true before accessing the
/// `success` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "success".
///
- (BOOL)isSuccess;

///
/// Retrieves whether the union's current tag state has value
/// "team_license_limit".
///
/// @note Call this method and ensure it returns true before accessing the
/// `teamLicenseLimit` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "team_license_limit".
///
- (BOOL)isTeamLicenseLimit;

///
/// Retrieves whether the union's current tag state has value
/// "free_team_member_limit_reached".
///
/// @note Call this method and ensure it returns true before accessing the
/// `freeTeamMemberLimitReached` property, otherwise a runtime exception will be
/// thrown.
///
/// @return Whether the union's current tag state has value
/// "free_team_member_limit_reached".
///
- (BOOL)isFreeTeamMemberLimitReached;

///
/// Retrieves whether the union's current tag state has value
/// "user_already_on_team".
///
/// @note Call this method and ensure it returns true before accessing the
/// `userAlreadyOnTeam` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "user_already_on_team".
///
- (BOOL)isUserAlreadyOnTeam;

///
/// Retrieves whether the union's current tag state has value
/// "user_on_another_team".
///
/// @note Call this method and ensure it returns true before accessing the
/// `userOnAnotherTeam` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "user_on_another_team".
///
- (BOOL)isUserOnAnotherTeam;

///
/// Retrieves whether the union's current tag state has value
/// "user_already_paired".
///
/// @note Call this method and ensure it returns true before accessing the
/// `userAlreadyPaired` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "user_already_paired".
///
- (BOOL)isUserAlreadyPaired;

///
/// Retrieves whether the union's current tag state has value
/// "user_migration_failed".
///
/// @note Call this method and ensure it returns true before accessing the
/// `userMigrationFailed` property, otherwise a runtime exception will be
/// thrown.
///
/// @return Whether the union's current tag state has value
/// "user_migration_failed".
///
- (BOOL)isUserMigrationFailed;

///
/// Retrieves whether the union's current tag state has value
/// "duplicate_external_member_id".
///
/// @note Call this method and ensure it returns true before accessing the
/// `duplicateExternalMemberId` property, otherwise a runtime exception will be
/// thrown.
///
/// @return Whether the union's current tag state has value
/// "duplicate_external_member_id".
///
- (BOOL)isDuplicateExternalMemberId;

///
/// Retrieves whether the union's current tag state has value
/// "duplicate_member_persistent_id".
///
/// @note Call this method and ensure it returns true before accessing the
/// `duplicateMemberPersistentId` property, otherwise a runtime exception will
/// be thrown.
///
/// @return Whether the union's current tag state has value
/// "duplicate_member_persistent_id".
///
- (BOOL)isDuplicateMemberPersistentId;

///
/// Retrieves whether the union's current tag state has value
/// "persistent_id_disabled".
///
/// @note Call this method and ensure it returns true before accessing the
/// `persistentIdDisabled` property, otherwise a runtime exception will be
/// thrown.
///
/// @return Whether the union's current tag state has value
/// "persistent_id_disabled".
///
- (BOOL)isPersistentIdDisabled;

///
/// Retrieves whether the union's current tag state has value
/// "user_creation_failed".
///
/// @note Call this method and ensure it returns true before accessing the
/// `userCreationFailed` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "user_creation_failed".
///
- (BOOL)isUserCreationFailed;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMMemberAddResult` union.
///
@interface DBTEAMMemberAddResultSerializer : NSObject

///
/// Serializes `DBTEAMMemberAddResult` instances.
///
/// @param instance An instance of the `DBTEAMMemberAddResult` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMemberAddResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberAddResult *)instance;

///
/// Deserializes `DBTEAMMemberAddResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMemberAddResult` API object.
///
/// @return An instantiation of the `DBTEAMMemberAddResult` object.
///
+ (DBTEAMMemberAddResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
