///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMListMembersAppsArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListMembersAppsArg` struct.
///
/// Arguments for `linkedAppsListMembersLinkedApps`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMListMembersAppsArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// At the first call to the `linkedAppsListMembersLinkedApps` the cursor
/// shouldn't be passed. Then, if the result of the call includes a cursor, the
/// following requests should include the received cursors in order to receive
/// the next sub list of the team applications.
@property (nonatomic, readonly, copy, nullable) NSString *cursor;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param cursor At the first call to the `linkedAppsListMembersLinkedApps` the
/// cursor shouldn't be passed. Then, if the result of the call includes a
/// cursor, the following requests should include the received cursors in order
/// to receive the next sub list of the team applications.
///
/// @return An initialized instance.
///
- (instancetype)initWithCursor:(nullable NSString *)cursor;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListMembersAppsArg` struct.
///
@interface DBTEAMListMembersAppsArgSerializer : NSObject

///
/// Serializes `DBTEAMListMembersAppsArg` instances.
///
/// @param instance An instance of the `DBTEAMListMembersAppsArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMListMembersAppsArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMListMembersAppsArg *)instance;

///
/// Deserializes `DBTEAMListMembersAppsArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMListMembersAppsArg` API object.
///
/// @return An instantiation of the `DBTEAMListMembersAppsArg` object.
///
+ (DBTEAMListMembersAppsArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
