///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails;
@class DBTEAMLOGSharedFolderMembersInheritancePolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedFolderChangeMembersInheritancePolicyDetails` struct.
///
/// Changed whether shared folder inherits members from parent folder.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New member inheritance policy.
@property (nonatomic, readonly) DBTEAMLOGSharedFolderMembersInheritancePolicy *dNewValue;

/// Previous member inheritance policy. Might be missing due to historical data
/// gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGSharedFolderMembersInheritancePolicy *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New member inheritance policy.
/// @param previousValue Previous member inheritance policy. Might be missing
/// due to historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGSharedFolderMembersInheritancePolicy *)dNewValue
                    previousValue:(nullable DBTEAMLOGSharedFolderMembersInheritancePolicy *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param dNewValue New member inheritance policy.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGSharedFolderMembersInheritancePolicy *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the
/// `SharedFolderChangeMembersInheritancePolicyDetails` struct.
///
@interface DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails`
/// instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:
    (DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails *)instance;

///
/// Deserializes `DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails`
/// instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails` object.
///
+ (DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
