///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGFolderLogInfo;
@class DBTEAMLOGJoinTeamDetails;
@class DBTEAMLOGLinkedDeviceLogInfo;
@class DBTEAMLOGUserLinkedAppLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `JoinTeamDetails` struct.
///
/// Additional information relevant when a new member joins the team.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGJoinTeamDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Linked applications. (Deprecated) Please use has_linked_apps boolean field
/// instead.
@property (nonatomic, readonly) NSArray<DBTEAMLOGUserLinkedAppLogInfo *> *linkedApps;

/// Linked devices. (Deprecated) Please use has_linked_devices boolean field
/// instead.
@property (nonatomic, readonly) NSArray<DBTEAMLOGLinkedDeviceLogInfo *> *linkedDevices;

/// Linked shared folders. (Deprecated) Please use has_linked_shared_folders
/// boolean field instead.
@property (nonatomic, readonly) NSArray<DBTEAMLOGFolderLogInfo *> *linkedSharedFolders;

/// (Deprecated) True if the linked_apps list was truncated to the maximum
/// supported length (50).
@property (nonatomic, readonly, nullable) NSNumber *wasLinkedAppsTruncated;

/// (Deprecated) True if the linked_devices list was truncated to the maximum
/// supported length (50).
@property (nonatomic, readonly, nullable) NSNumber *wasLinkedDevicesTruncated;

/// (Deprecated) True if the linked_shared_folders list was truncated to the
/// maximum supported length (50).
@property (nonatomic, readonly, nullable) NSNumber *wasLinkedSharedFoldersTruncated;

/// True if the user had linked apps at event time.
@property (nonatomic, readonly, nullable) NSNumber *hasLinkedApps;

/// True if the user had linked apps at event time.
@property (nonatomic, readonly, nullable) NSNumber *hasLinkedDevices;

/// True if the user had linked shared folders at event time.
@property (nonatomic, readonly, nullable) NSNumber *hasLinkedSharedFolders;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param linkedApps Linked applications. (Deprecated) Please use
/// has_linked_apps boolean field instead.
/// @param linkedDevices Linked devices. (Deprecated) Please use
/// has_linked_devices boolean field instead.
/// @param linkedSharedFolders Linked shared folders. (Deprecated) Please use
/// has_linked_shared_folders boolean field instead.
/// @param wasLinkedAppsTruncated (Deprecated) True if the linked_apps list was
/// truncated to the maximum supported length (50).
/// @param wasLinkedDevicesTruncated (Deprecated) True if the linked_devices
/// list was truncated to the maximum supported length (50).
/// @param wasLinkedSharedFoldersTruncated (Deprecated) True if the
/// linked_shared_folders list was truncated to the maximum supported length
/// (50).
/// @param hasLinkedApps True if the user had linked apps at event time.
/// @param hasLinkedDevices True if the user had linked apps at event time.
/// @param hasLinkedSharedFolders True if the user had linked shared folders at
/// event time.
///
/// @return An initialized instance.
///
- (instancetype)initWithLinkedApps:(NSArray<DBTEAMLOGUserLinkedAppLogInfo *> *)linkedApps
                      linkedDevices:(NSArray<DBTEAMLOGLinkedDeviceLogInfo *> *)linkedDevices
                linkedSharedFolders:(NSArray<DBTEAMLOGFolderLogInfo *> *)linkedSharedFolders
             wasLinkedAppsTruncated:(nullable NSNumber *)wasLinkedAppsTruncated
          wasLinkedDevicesTruncated:(nullable NSNumber *)wasLinkedDevicesTruncated
    wasLinkedSharedFoldersTruncated:(nullable NSNumber *)wasLinkedSharedFoldersTruncated
                      hasLinkedApps:(nullable NSNumber *)hasLinkedApps
                   hasLinkedDevices:(nullable NSNumber *)hasLinkedDevices
             hasLinkedSharedFolders:(nullable NSNumber *)hasLinkedSharedFolders;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param linkedApps Linked applications. (Deprecated) Please use
/// has_linked_apps boolean field instead.
/// @param linkedDevices Linked devices. (Deprecated) Please use
/// has_linked_devices boolean field instead.
/// @param linkedSharedFolders Linked shared folders. (Deprecated) Please use
/// has_linked_shared_folders boolean field instead.
///
/// @return An initialized instance.
///
- (instancetype)initWithLinkedApps:(NSArray<DBTEAMLOGUserLinkedAppLogInfo *> *)linkedApps
                     linkedDevices:(NSArray<DBTEAMLOGLinkedDeviceLogInfo *> *)linkedDevices
               linkedSharedFolders:(NSArray<DBTEAMLOGFolderLogInfo *> *)linkedSharedFolders;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `JoinTeamDetails` struct.
///
@interface DBTEAMLOGJoinTeamDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGJoinTeamDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGJoinTeamDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGJoinTeamDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGJoinTeamDetails *)instance;

///
/// Deserializes `DBTEAMLOGJoinTeamDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGJoinTeamDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGJoinTeamDetails` object.
///
+ (DBTEAMLOGJoinTeamDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
