///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMCOMMONGroupManagementType;
@class DBTEAMLOGGroupChangeManagementTypeDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GroupChangeManagementTypeDetails` struct.
///
/// Changed group management type.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGroupChangeManagementTypeDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New group management type.
@property (nonatomic, readonly) DBTEAMCOMMONGroupManagementType *dNewValue;

/// Previous group management type. Might be missing due to historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMCOMMONGroupManagementType *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New group management type.
/// @param previousValue Previous group management type. Might be missing due to
/// historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMCOMMONGroupManagementType *)dNewValue
                    previousValue:(nullable DBTEAMCOMMONGroupManagementType *)previousValue;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param dNewValue New group management type.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMCOMMONGroupManagementType *)dNewValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GroupChangeManagementTypeDetails` struct.
///
@interface DBTEAMLOGGroupChangeManagementTypeDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGroupChangeManagementTypeDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGroupChangeManagementTypeDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGroupChangeManagementTypeDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGroupChangeManagementTypeDetails *)instance;

///
/// Deserializes `DBTEAMLOGGroupChangeManagementTypeDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGroupChangeManagementTypeDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGGroupChangeManagementTypeDetails`
/// object.
///
+ (DBTEAMLOGGroupChangeManagementTypeDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
