///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGCertificate;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `Certificate` struct.
///
/// Certificate details.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGCertificate : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Certificate subject.
@property (nonatomic, readonly, copy) NSString *subject;

/// Certificate issuer.
@property (nonatomic, readonly, copy) NSString *issuer;

/// Certificate issue date.
@property (nonatomic, readonly, copy) NSString *issueDate;

/// Certificate expiration date.
@property (nonatomic, readonly, copy) NSString *expirationDate;

/// Certificate serial number.
@property (nonatomic, readonly, copy) NSString *serialNumber;

/// Certificate sha1 fingerprint.
@property (nonatomic, readonly, copy) NSString *sha1Fingerprint;

/// Certificate common name.
@property (nonatomic, readonly, copy, nullable) NSString *commonName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param subject Certificate subject.
/// @param issuer Certificate issuer.
/// @param issueDate Certificate issue date.
/// @param expirationDate Certificate expiration date.
/// @param serialNumber Certificate serial number.
/// @param sha1Fingerprint Certificate sha1 fingerprint.
/// @param commonName Certificate common name.
///
/// @return An initialized instance.
///
- (instancetype)initWithSubject:(NSString *)subject
                         issuer:(NSString *)issuer
                      issueDate:(NSString *)issueDate
                 expirationDate:(NSString *)expirationDate
                   serialNumber:(NSString *)serialNumber
                sha1Fingerprint:(NSString *)sha1Fingerprint
                     commonName:(nullable NSString *)commonName;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param subject Certificate subject.
/// @param issuer Certificate issuer.
/// @param issueDate Certificate issue date.
/// @param expirationDate Certificate expiration date.
/// @param serialNumber Certificate serial number.
/// @param sha1Fingerprint Certificate sha1 fingerprint.
///
/// @return An initialized instance.
///
- (instancetype)initWithSubject:(NSString *)subject
                         issuer:(NSString *)issuer
                      issueDate:(NSString *)issueDate
                 expirationDate:(NSString *)expirationDate
                   serialNumber:(NSString *)serialNumber
                sha1Fingerprint:(NSString *)sha1Fingerprint;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `Certificate` struct.
///
@interface DBTEAMLOGCertificateSerializer : NSObject

///
/// Serializes `DBTEAMLOGCertificate` instances.
///
/// @param instance An instance of the `DBTEAMLOGCertificate` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGCertificate` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCertificate *)instance;

///
/// Deserializes `DBTEAMLOGCertificate` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGCertificate` API object.
///
/// @return An instantiation of the `DBTEAMLOGCertificate` object.
///
+ (DBTEAMLOGCertificate *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
