///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminAlertingAlertConfiguration;
@class DBTEAMLOGAdminAlertingChangedAlertConfigDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AdminAlertingChangedAlertConfigDetails` struct.
///
/// Changed an alert setting.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAdminAlertingChangedAlertConfigDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Alert Name.
@property (nonatomic, readonly, copy) NSString *alertName;

/// Previous alert configuration.
@property (nonatomic, readonly) DBTEAMLOGAdminAlertingAlertConfiguration *previousAlertConfig;

/// New alert configuration.
@property (nonatomic, readonly) DBTEAMLOGAdminAlertingAlertConfiguration *dNewAlertConfig;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param alertName Alert Name.
/// @param previousAlertConfig Previous alert configuration.
/// @param dNewAlertConfig New alert configuration.
///
/// @return An initialized instance.
///
- (instancetype)initWithAlertName:(NSString *)alertName
              previousAlertConfig:(DBTEAMLOGAdminAlertingAlertConfiguration *)previousAlertConfig
                  dNewAlertConfig:(DBTEAMLOGAdminAlertingAlertConfiguration *)dNewAlertConfig;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `AdminAlertingChangedAlertConfigDetails`
/// struct.
///
@interface DBTEAMLOGAdminAlertingChangedAlertConfigDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGAdminAlertingChangedAlertConfigDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGAdminAlertingChangedAlertConfigDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingChangedAlertConfigDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingChangedAlertConfigDetails *)instance;

///
/// Deserializes `DBTEAMLOGAdminAlertingChangedAlertConfigDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingChangedAlertConfigDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGAdminAlertingChangedAlertConfigDetails` object.
///
+ (DBTEAMLOGAdminAlertingChangedAlertConfigDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
