///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminAlertingAlertConfiguration;
@class DBTEAMLOGAdminAlertingAlertSensitivity;
@class DBTEAMLOGAdminAlertingAlertStatePolicy;
@class DBTEAMLOGRecipientsConfiguration;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AdminAlertingAlertConfiguration` struct.
///
/// Alert configurations
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAdminAlertingAlertConfiguration : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Alert state.
@property (nonatomic, readonly, nullable) DBTEAMLOGAdminAlertingAlertStatePolicy *alertState;

/// Sensitivity level.
@property (nonatomic, readonly, nullable) DBTEAMLOGAdminAlertingAlertSensitivity *sensitivityLevel;

/// Recipient settings.
@property (nonatomic, readonly, nullable) DBTEAMLOGRecipientsConfiguration *recipientsSettings;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param alertState Alert state.
/// @param sensitivityLevel Sensitivity level.
/// @param recipientsSettings Recipient settings.
///
/// @return An initialized instance.
///
- (instancetype)initWithAlertState:(nullable DBTEAMLOGAdminAlertingAlertStatePolicy *)alertState
                  sensitivityLevel:(nullable DBTEAMLOGAdminAlertingAlertSensitivity *)sensitivityLevel
                recipientsSettings:(nullable DBTEAMLOGRecipientsConfiguration *)recipientsSettings;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `AdminAlertingAlertConfiguration` struct.
///
@interface DBTEAMLOGAdminAlertingAlertConfigurationSerializer : NSObject

///
/// Serializes `DBTEAMLOGAdminAlertingAlertConfiguration` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGAdminAlertingAlertConfiguration` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingAlertConfiguration` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingAlertConfiguration *)instance;

///
/// Deserializes `DBTEAMLOGAdminAlertingAlertConfiguration` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingAlertConfiguration` API object.
///
/// @return An instantiation of the `DBTEAMLOGAdminAlertingAlertConfiguration`
/// object.
///
+ (DBTEAMLOGAdminAlertingAlertConfiguration *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
