///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAccountCaptureNotificationEmailsSentDetails;
@class DBTEAMLOGAccountCaptureNotificationType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AccountCaptureNotificationEmailsSentDetails` struct.
///
/// Sent account capture email to all unmanaged members.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAccountCaptureNotificationEmailsSentDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Domain name.
@property (nonatomic, readonly, copy) NSString *domainName;

/// Account-capture email notification type.
@property (nonatomic, readonly, nullable) DBTEAMLOGAccountCaptureNotificationType *notificationType;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param domainName Domain name.
/// @param notificationType Account-capture email notification type.
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainName:(NSString *)domainName
                  notificationType:(nullable DBTEAMLOGAccountCaptureNotificationType *)notificationType;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param domainName Domain name.
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainName:(NSString *)domainName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the
/// `AccountCaptureNotificationEmailsSentDetails` struct.
///
@interface DBTEAMLOGAccountCaptureNotificationEmailsSentDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGAccountCaptureNotificationEmailsSentDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGAccountCaptureNotificationEmailsSentDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAccountCaptureNotificationEmailsSentDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureNotificationEmailsSentDetails *)instance;

///
/// Deserializes `DBTEAMLOGAccountCaptureNotificationEmailsSentDetails`
/// instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAccountCaptureNotificationEmailsSentDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGAccountCaptureNotificationEmailsSentDetails` object.
///
+ (DBTEAMLOGAccountCaptureNotificationEmailsSentDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
