///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGSharedLinkAlreadyExistsMetadata;
@class DBSHARINGSharedLinkMetadata;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedLinkAlreadyExistsMetadata` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGSharedLinkAlreadyExistsMetadata : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGSharedLinkAlreadyExistsMetadataTag` enum type represents the
/// possible tag states with which the
/// `DBSHARINGSharedLinkAlreadyExistsMetadata` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGSharedLinkAlreadyExistsMetadataTag){
    /// Metadata of the shared link that already exists.
    DBSHARINGSharedLinkAlreadyExistsMetadataMetadata,

    /// (no description).
    DBSHARINGSharedLinkAlreadyExistsMetadataOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGSharedLinkAlreadyExistsMetadataTag tag;

/// Metadata of the shared link that already exists. @note Ensure the
/// `isMetadata` method returns true before accessing, otherwise a runtime
/// exception will be raised.
@property (nonatomic, readonly) DBSHARINGSharedLinkMetadata *metadata;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "metadata".
///
/// Description of the "metadata" tag state: Metadata of the shared link that
/// already exists.
///
/// @param metadata Metadata of the shared link that already exists.
///
/// @return An initialized instance.
///
- (instancetype)initWithMetadata:(DBSHARINGSharedLinkMetadata *)metadata;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "metadata".
///
/// @note Call this method and ensure it returns true before accessing the
/// `metadata` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "metadata".
///
- (BOOL)isMetadata;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGSharedLinkAlreadyExistsMetadata`
/// union.
///
@interface DBSHARINGSharedLinkAlreadyExistsMetadataSerializer : NSObject

///
/// Serializes `DBSHARINGSharedLinkAlreadyExistsMetadata` instances.
///
/// @param instance An instance of the
/// `DBSHARINGSharedLinkAlreadyExistsMetadata` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGSharedLinkAlreadyExistsMetadata` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkAlreadyExistsMetadata *)instance;

///
/// Deserializes `DBSHARINGSharedLinkAlreadyExistsMetadata` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGSharedLinkAlreadyExistsMetadata` API object.
///
/// @return An instantiation of the `DBSHARINGSharedLinkAlreadyExistsMetadata`
/// object.
///
+ (DBSHARINGSharedLinkAlreadyExistsMetadata *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
