///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGMemberSelector;
@class DBSHARINGRemoveFolderMemberArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `RemoveFolderMemberArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGRemoveFolderMemberArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The ID for the shared folder.
@property (nonatomic, readonly, copy) NSString *sharedFolderId;

/// The member to remove from the folder.
@property (nonatomic, readonly) DBSHARINGMemberSelector *member;

/// If true, the removed user will keep their copy of the folder after it's
/// unshared, assuming it was mounted. Otherwise, it will be removed from their
/// Dropbox. Also, this must be set to false when kicking a group.
@property (nonatomic, readonly) NSNumber *leaveACopy;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sharedFolderId The ID for the shared folder.
/// @param member The member to remove from the folder.
/// @param leaveACopy If true, the removed user will keep their copy of the
/// folder after it's unshared, assuming it was mounted. Otherwise, it will be
/// removed from their Dropbox. Also, this must be set to false when kicking a
/// group.
///
/// @return An initialized instance.
///
- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                                member:(DBSHARINGMemberSelector *)member
                            leaveACopy:(NSNumber *)leaveACopy;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `RemoveFolderMemberArg` struct.
///
@interface DBSHARINGRemoveFolderMemberArgSerializer : NSObject

///
/// Serializes `DBSHARINGRemoveFolderMemberArg` instances.
///
/// @param instance An instance of the `DBSHARINGRemoveFolderMemberArg` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGRemoveFolderMemberArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGRemoveFolderMemberArg *)instance;

///
/// Deserializes `DBSHARINGRemoveFolderMemberArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGRemoveFolderMemberArg` API object.
///
/// @return An instantiation of the `DBSHARINGRemoveFolderMemberArg` object.
///
+ (DBSHARINGRemoveFolderMemberArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
