///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBPAPERPaperDocPermissionLevel;
@class DBPAPERUserInfoWithPermissionLevel;
@class DBSHARINGUserInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UserInfoWithPermissionLevel` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERUserInfoWithPermissionLevel : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// User shared on the Paper doc.
@property (nonatomic, readonly) DBSHARINGUserInfo *user;

/// Permission level for the user.
@property (nonatomic, readonly) DBPAPERPaperDocPermissionLevel *permissionLevel;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param user User shared on the Paper doc.
/// @param permissionLevel Permission level for the user.
///
/// @return An initialized instance.
///
- (instancetype)initWithUser:(DBSHARINGUserInfo *)user
             permissionLevel:(DBPAPERPaperDocPermissionLevel *)permissionLevel;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `UserInfoWithPermissionLevel` struct.
///
@interface DBPAPERUserInfoWithPermissionLevelSerializer : NSObject

///
/// Serializes `DBPAPERUserInfoWithPermissionLevel` instances.
///
/// @param instance An instance of the `DBPAPERUserInfoWithPermissionLevel` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERUserInfoWithPermissionLevel` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERUserInfoWithPermissionLevel *)instance;

///
/// Deserializes `DBPAPERUserInfoWithPermissionLevel` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERUserInfoWithPermissionLevel` API object.
///
/// @return An instantiation of the `DBPAPERUserInfoWithPermissionLevel` object.
///
+ (DBPAPERUserInfoWithPermissionLevel *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
