///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBPAPERPaperFolderCreateError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperFolderCreateError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERPaperFolderCreateError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBPAPERPaperFolderCreateErrorTag` enum type represents the possible tag
/// states with which the `DBPAPERPaperFolderCreateError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBPAPERPaperFolderCreateErrorTag){
    /// Your account does not have permissions to perform this action. This may
    /// be due to it only having access to Paper as files in the Dropbox
    /// filesystem. For more information, refer to the Paper Migration Guide
    /// https://www.dropbox.com/lp/developers/reference/paper-migration-guide.
    DBPAPERPaperFolderCreateErrorInsufficientPermissions,

    /// (no description).
    DBPAPERPaperFolderCreateErrorOther,

    /// The specified parent Paper folder cannot be found.
    DBPAPERPaperFolderCreateErrorFolderNotFound,

    /// The folder id cannot be decrypted to valid folder id.
    DBPAPERPaperFolderCreateErrorInvalidFolderId,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBPAPERPaperFolderCreateErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "insufficient_permissions".
///
/// Description of the "insufficient_permissions" tag state: Your account does
/// not have permissions to perform this action. This may be due to it only
/// having access to Paper as files in the Dropbox filesystem. For more
/// information, refer to the Paper Migration Guide
/// https://www.dropbox.com/lp/developers/reference/paper-migration-guide.
///
/// @return An initialized instance.
///
- (instancetype)initWithInsufficientPermissions;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of "folder_not_found".
///
/// Description of the "folder_not_found" tag state: The specified parent Paper
/// folder cannot be found.
///
/// @return An initialized instance.
///
- (instancetype)initWithFolderNotFound;

///
/// Initializes union class with tag state of "invalid_folder_id".
///
/// Description of the "invalid_folder_id" tag state: The folder id cannot be
/// decrypted to valid folder id.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidFolderId;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "insufficient_permissions".
///
/// @return Whether the union's current tag state has value
/// "insufficient_permissions".
///
- (BOOL)isInsufficientPermissions;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value
/// "folder_not_found".
///
/// @return Whether the union's current tag state has value "folder_not_found".
///
- (BOOL)isFolderNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "invalid_folder_id".
///
/// @return Whether the union's current tag state has value "invalid_folder_id".
///
- (BOOL)isInvalidFolderId;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBPAPERPaperFolderCreateError` union.
///
@interface DBPAPERPaperFolderCreateErrorSerializer : NSObject

///
/// Serializes `DBPAPERPaperFolderCreateError` instances.
///
/// @param instance An instance of the `DBPAPERPaperFolderCreateError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERPaperFolderCreateError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperFolderCreateError *)instance;

///
/// Deserializes `DBPAPERPaperFolderCreateError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERPaperFolderCreateError` API object.
///
/// @return An instantiation of the `DBPAPERPaperFolderCreateError` object.
///
+ (DBPAPERPaperFolderCreateError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
