///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBPAPERPaperDocCreateUpdateResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperDocCreateUpdateResult` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERPaperDocCreateUpdateResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Doc ID of the newly created doc.
@property (nonatomic, readonly, copy) NSString *docId;

/// The Paper doc revision. Simply an ever increasing number.
@property (nonatomic, readonly) NSNumber *revision;

/// The Paper doc title.
@property (nonatomic, readonly, copy) NSString *title;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param docId Doc ID of the newly created doc.
/// @param revision The Paper doc revision. Simply an ever increasing number.
/// @param title The Paper doc title.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocId:(NSString *)docId revision:(NSNumber *)revision title:(NSString *)title;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PaperDocCreateUpdateResult` struct.
///
@interface DBPAPERPaperDocCreateUpdateResultSerializer : NSObject

///
/// Serializes `DBPAPERPaperDocCreateUpdateResult` instances.
///
/// @param instance An instance of the `DBPAPERPaperDocCreateUpdateResult` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERPaperDocCreateUpdateResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocCreateUpdateResult *)instance;

///
/// Deserializes `DBPAPERPaperDocCreateUpdateResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERPaperDocCreateUpdateResult` API object.
///
/// @return An instantiation of the `DBPAPERPaperDocCreateUpdateResult` object.
///
+ (DBPAPERPaperDocCreateUpdateResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
