///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILEPROPERTIESInvalidPropertyGroupError;
@class DBFILESUploadSessionFinishError;
@class DBFILESUploadSessionLookupError;
@class DBFILESWriteError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UploadSessionFinishError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESUploadSessionFinishError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESUploadSessionFinishErrorTag` enum type represents the possible
/// tag states with which the `DBFILESUploadSessionFinishError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESUploadSessionFinishErrorTag){
    /// The session arguments are incorrect; the value explains the reason.
    DBFILESUploadSessionFinishErrorLookupFailed,

    /// Unable to save the uploaded contents to a file. Data has already been
    /// appended to the upload session. Please retry with empty data body and
    /// updated offset.
    DBFILESUploadSessionFinishErrorPath,

    /// The supplied property group is invalid. The file has uploaded without
    /// property groups.
    DBFILESUploadSessionFinishErrorPropertiesError,

    /// The batch request commits files into too many different shared folders.
    /// Please limit your batch request to files contained in a single shared
    /// folder.
    DBFILESUploadSessionFinishErrorTooManySharedFolderTargets,

    /// There are too many write operations happening in the user's Dropbox. You
    /// should retry uploading this file.
    DBFILESUploadSessionFinishErrorTooManyWriteOperations,

    /// Uploading data not allowed when finishing concurrent upload session.
    DBFILESUploadSessionFinishErrorConcurrentSessionDataNotAllowed,

    /// Concurrent upload sessions need to be closed before finishing.
    DBFILESUploadSessionFinishErrorConcurrentSessionNotClosed,

    /// Not all pieces of data were uploaded before trying to finish the
    /// session.
    DBFILESUploadSessionFinishErrorConcurrentSessionMissingData,

    /// (no description).
    DBFILESUploadSessionFinishErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESUploadSessionFinishErrorTag tag;

/// The session arguments are incorrect; the value explains the reason. @note
/// Ensure the `isLookupFailed` method returns true before accessing, otherwise
/// a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESUploadSessionLookupError *lookupFailed;

/// Unable to save the uploaded contents to a file. Data has already been
/// appended to the upload session. Please retry with empty data body and
/// updated offset. @note Ensure the `isPath` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESWriteError *path;

/// The supplied property group is invalid. The file has uploaded without
/// property groups. @note Ensure the `isPropertiesError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILEPROPERTIESInvalidPropertyGroupError *propertiesError;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "lookup_failed".
///
/// Description of the "lookup_failed" tag state: The session arguments are
/// incorrect; the value explains the reason.
///
/// @param lookupFailed The session arguments are incorrect; the value explains
/// the reason.
///
/// @return An initialized instance.
///
- (instancetype)initWithLookupFailed:(DBFILESUploadSessionLookupError *)lookupFailed;

///
/// Initializes union class with tag state of "path".
///
/// Description of the "path" tag state: Unable to save the uploaded contents to
/// a file. Data has already been appended to the upload session. Please retry
/// with empty data body and updated offset.
///
/// @param path Unable to save the uploaded contents to a file. Data has already
/// been appended to the upload session. Please retry with empty data body and
/// updated offset.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBFILESWriteError *)path;

///
/// Initializes union class with tag state of "properties_error".
///
/// Description of the "properties_error" tag state: The supplied property group
/// is invalid. The file has uploaded without property groups.
///
/// @param propertiesError The supplied property group is invalid. The file has
/// uploaded without property groups.
///
/// @return An initialized instance.
///
- (instancetype)initWithPropertiesError:(DBFILEPROPERTIESInvalidPropertyGroupError *)propertiesError;

///
/// Initializes union class with tag state of "too_many_shared_folder_targets".
///
/// Description of the "too_many_shared_folder_targets" tag state: The batch
/// request commits files into too many different shared folders. Please limit
/// your batch request to files contained in a single shared folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManySharedFolderTargets;

///
/// Initializes union class with tag state of "too_many_write_operations".
///
/// Description of the "too_many_write_operations" tag state: There are too many
/// write operations happening in the user's Dropbox. You should retry uploading
/// this file.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyWriteOperations;

///
/// Initializes union class with tag state of
/// "concurrent_session_data_not_allowed".
///
/// Description of the "concurrent_session_data_not_allowed" tag state:
/// Uploading data not allowed when finishing concurrent upload session.
///
/// @return An initialized instance.
///
- (instancetype)initWithConcurrentSessionDataNotAllowed;

///
/// Initializes union class with tag state of "concurrent_session_not_closed".
///
/// Description of the "concurrent_session_not_closed" tag state: Concurrent
/// upload sessions need to be closed before finishing.
///
/// @return An initialized instance.
///
- (instancetype)initWithConcurrentSessionNotClosed;

///
/// Initializes union class with tag state of "concurrent_session_missing_data".
///
/// Description of the "concurrent_session_missing_data" tag state: Not all
/// pieces of data were uploaded before trying to finish the session.
///
/// @return An initialized instance.
///
- (instancetype)initWithConcurrentSessionMissingData;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "lookup_failed".
///
/// @note Call this method and ensure it returns true before accessing the
/// `lookupFailed` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "lookup_failed".
///
- (BOOL)isLookupFailed;

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value
/// "properties_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `propertiesError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "properties_error".
///
- (BOOL)isPropertiesError;

///
/// Retrieves whether the union's current tag state has value
/// "too_many_shared_folder_targets".
///
/// @return Whether the union's current tag state has value
/// "too_many_shared_folder_targets".
///
- (BOOL)isTooManySharedFolderTargets;

///
/// Retrieves whether the union's current tag state has value
/// "too_many_write_operations".
///
/// @return Whether the union's current tag state has value
/// "too_many_write_operations".
///
- (BOOL)isTooManyWriteOperations;

///
/// Retrieves whether the union's current tag state has value
/// "concurrent_session_data_not_allowed".
///
/// @return Whether the union's current tag state has value
/// "concurrent_session_data_not_allowed".
///
- (BOOL)isConcurrentSessionDataNotAllowed;

///
/// Retrieves whether the union's current tag state has value
/// "concurrent_session_not_closed".
///
/// @return Whether the union's current tag state has value
/// "concurrent_session_not_closed".
///
- (BOOL)isConcurrentSessionNotClosed;

///
/// Retrieves whether the union's current tag state has value
/// "concurrent_session_missing_data".
///
/// @return Whether the union's current tag state has value
/// "concurrent_session_missing_data".
///
- (BOOL)isConcurrentSessionMissingData;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESUploadSessionFinishError` union.
///
@interface DBFILESUploadSessionFinishErrorSerializer : NSObject

///
/// Serializes `DBFILESUploadSessionFinishError` instances.
///
/// @param instance An instance of the `DBFILESUploadSessionFinishError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESUploadSessionFinishError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionFinishError *)instance;

///
/// Deserializes `DBFILESUploadSessionFinishError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESUploadSessionFinishError` API object.
///
/// @return An instantiation of the `DBFILESUploadSessionFinishError` object.
///
+ (DBFILESUploadSessionFinishError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
