///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESUploadSessionCursor;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UploadSessionCursor` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESUploadSessionCursor : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The upload session ID (returned by `uploadSessionStart`).
@property (nonatomic, readonly, copy) NSString *sessionId;

/// Offset in bytes at which data should be appended. We use this to make sure
/// upload data isn't lost or duplicated in the event of a network error.
@property (nonatomic, readonly) NSNumber *offset;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param sessionId The upload session ID (returned by `uploadSessionStart`).
/// @param offset Offset in bytes at which data should be appended. We use this
/// to make sure upload data isn't lost or duplicated in the event of a network
/// error.
///
/// @return An initialized instance.
///
- (instancetype)initWithSessionId:(NSString *)sessionId offset:(NSNumber *)offset;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `UploadSessionCursor` struct.
///
@interface DBFILESUploadSessionCursorSerializer : NSObject

///
/// Serializes `DBFILESUploadSessionCursor` instances.
///
/// @param instance An instance of the `DBFILESUploadSessionCursor` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESUploadSessionCursor` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESUploadSessionCursor *)instance;

///
/// Deserializes `DBFILESUploadSessionCursor` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESUploadSessionCursor` API object.
///
/// @return An instantiation of the `DBFILESUploadSessionCursor` object.
///
+ (DBFILESUploadSessionCursor *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
