///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESRelocationBatchErrorEntry;
@class DBFILESRelocationError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `RelocationBatchErrorEntry` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESRelocationBatchErrorEntry : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESRelocationBatchErrorEntryTag` enum type represents the possible
/// tag states with which the `DBFILESRelocationBatchErrorEntry` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESRelocationBatchErrorEntryTag){
    /// User errors that retry won't help.
    DBFILESRelocationBatchErrorEntryRelocationError,

    /// Something went wrong with the job on Dropbox's end. You'll need to
    /// verify that the action you were taking succeeded, and if not, try again.
    /// This should happen very rarely.
    DBFILESRelocationBatchErrorEntryInternalError,

    /// There are too many write operations in user's Dropbox. Please retry this
    /// request.
    DBFILESRelocationBatchErrorEntryTooManyWriteOperations,

    /// (no description).
    DBFILESRelocationBatchErrorEntryOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESRelocationBatchErrorEntryTag tag;

/// User errors that retry won't help. @note Ensure the `isRelocationError`
/// method returns true before accessing, otherwise a runtime exception will be
/// raised.
@property (nonatomic, readonly) DBFILESRelocationError *relocationError;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "relocation_error".
///
/// Description of the "relocation_error" tag state: User errors that retry
/// won't help.
///
/// @param relocationError User errors that retry won't help.
///
/// @return An initialized instance.
///
- (instancetype)initWithRelocationError:(DBFILESRelocationError *)relocationError;

///
/// Initializes union class with tag state of "internal_error".
///
/// Description of the "internal_error" tag state: Something went wrong with the
/// job on Dropbox's end. You'll need to verify that the action you were taking
/// succeeded, and if not, try again. This should happen very rarely.
///
/// @return An initialized instance.
///
- (instancetype)initWithInternalError;

///
/// Initializes union class with tag state of "too_many_write_operations".
///
/// Description of the "too_many_write_operations" tag state: There are too many
/// write operations in user's Dropbox. Please retry this request.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyWriteOperations;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "relocation_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `relocationError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "relocation_error".
///
- (BOOL)isRelocationError;

///
/// Retrieves whether the union's current tag state has value "internal_error".
///
/// @return Whether the union's current tag state has value "internal_error".
///
- (BOOL)isInternalError;

///
/// Retrieves whether the union's current tag state has value
/// "too_many_write_operations".
///
/// @return Whether the union's current tag state has value
/// "too_many_write_operations".
///
- (BOOL)isTooManyWriteOperations;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESRelocationBatchErrorEntry` union.
///
@interface DBFILESRelocationBatchErrorEntrySerializer : NSObject

///
/// Serializes `DBFILESRelocationBatchErrorEntry` instances.
///
/// @param instance An instance of the `DBFILESRelocationBatchErrorEntry` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESRelocationBatchErrorEntry` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESRelocationBatchErrorEntry *)instance;

///
/// Deserializes `DBFILESRelocationBatchErrorEntry` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESRelocationBatchErrorEntry` API object.
///
/// @return An instantiation of the `DBFILESRelocationBatchErrorEntry` object.
///
+ (DBFILESRelocationBatchErrorEntry *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
