///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESListRevisionsMode;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListRevisionsMode` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESListRevisionsMode : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESListRevisionsModeTag` enum type represents the possible tag
/// states with which the `DBFILESListRevisionsMode` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESListRevisionsModeTag){
    /// Returns revisions with the same file path as identified by the latest
    /// file entry at the given file path or id.
    DBFILESListRevisionsModePath,

    /// Returns revisions with the same file id as identified by the latest file
    /// entry at the given file path or id.
    DBFILESListRevisionsModeId_,

    /// (no description).
    DBFILESListRevisionsModeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESListRevisionsModeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "path".
///
/// Description of the "path" tag state: Returns revisions with the same file
/// path as identified by the latest file entry at the given file path or id.
///
/// @return An initialized instance.
///
- (instancetype)initWithPath;

///
/// Initializes union class with tag state of "id".
///
/// Description of the "id" tag state: Returns revisions with the same file id
/// as identified by the latest file entry at the given file path or id.
///
/// @return An initialized instance.
///
- (instancetype)initWithId_;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value "id".
///
/// @return Whether the union's current tag state has value "id".
///
- (BOOL)isId_;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESListRevisionsMode` union.
///
@interface DBFILESListRevisionsModeSerializer : NSObject

///
/// Serializes `DBFILESListRevisionsMode` instances.
///
/// @param instance An instance of the `DBFILESListRevisionsMode` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESListRevisionsMode` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESListRevisionsMode *)instance;

///
/// Deserializes `DBFILESListRevisionsMode` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESListRevisionsMode` API object.
///
/// @return An instantiation of the `DBFILESListRevisionsMode` object.
///
+ (DBFILESListRevisionsMode *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
