///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESDeleteBatchError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeleteBatchError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESDeleteBatchError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESDeleteBatchErrorTag` enum type represents the possible tag
/// states with which the `DBFILESDeleteBatchError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESDeleteBatchErrorTag){
    /// Use `tooManyWriteOperations` in `DBFILESDeleteError`. `deleteBatch` now
    /// provides smaller granularity about which entry has failed because of
    /// this.
    DBFILESDeleteBatchErrorTooManyWriteOperations,

    /// (no description).
    DBFILESDeleteBatchErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESDeleteBatchErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "too_many_write_operations".
///
/// Description of the "too_many_write_operations" tag state: Use
/// `tooManyWriteOperations` in `DBFILESDeleteError`. `deleteBatch` now provides
/// smaller granularity about which entry has failed because of this.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyWriteOperations;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "too_many_write_operations".
///
/// @return Whether the union's current tag state has value
/// "too_many_write_operations".
///
- (BOOL)isTooManyWriteOperations;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESDeleteBatchError` union.
///
@interface DBFILESDeleteBatchErrorSerializer : NSObject

///
/// Serializes `DBFILESDeleteBatchError` instances.
///
/// @param instance An instance of the `DBFILESDeleteBatchError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESDeleteBatchError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESDeleteBatchError *)instance;

///
/// Deserializes `DBFILESDeleteBatchError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESDeleteBatchError` API object.
///
/// @return An instantiation of the `DBFILESDeleteBatchError` object.
///
+ (DBFILESDeleteBatchError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
