///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESContentSyncSettingArg;
@class DBFILESSyncSettingArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ContentSyncSettingArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESContentSyncSettingArg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Id of the item this setting is applied to.
@property (nonatomic, readonly, copy) NSString *id_;

/// Setting for this item.
@property (nonatomic, readonly) DBFILESSyncSettingArg *syncSetting;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param id_ Id of the item this setting is applied to.
/// @param syncSetting Setting for this item.
///
/// @return An initialized instance.
///
- (instancetype)initWithId_:(NSString *)id_ syncSetting:(DBFILESSyncSettingArg *)syncSetting;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ContentSyncSettingArg` struct.
///
@interface DBFILESContentSyncSettingArgSerializer : NSObject

///
/// Serializes `DBFILESContentSyncSettingArg` instances.
///
/// @param instance An instance of the `DBFILESContentSyncSettingArg` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESContentSyncSettingArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESContentSyncSettingArg *)instance;

///
/// Deserializes `DBFILESContentSyncSettingArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESContentSyncSettingArg` API object.
///
/// @return An instantiation of the `DBFILESContentSyncSettingArg` object.
///
+ (DBFILESContentSyncSettingArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
