//
//  UIColor+HexString.h
//  
//

#import <UIKit/UIKit.h>

@interface UIColor (HexString)

/**
 * 從Hex字串取得顏色物件
 *
 * @param hexString 支援的格式為 "#RRGGBB"
 * @return UIColor
 */
+ (UIColor *)colorWithHexString:(NSString *)hexString;



/**
 * 從Hex字串取得顏色物件
 *
 * @param hexString 支援的格式為 "#RRGGBB"
 * @param alpha 透明度
 * @return UIColor
 */
+ (UIColor *)colorWithHexString:(NSString *)hexString
                          alpha:(CGFloat)alpha;
@end
