//
//  WCToastView.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/9/13.
//  Copyright (c) 2015年 penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPToastController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCToastController : NSObject

/**
 * 顯示SectionIndex用的toast, size{75,75}，位置一定是置中
 * @param superView toast 的superview
 * @param title toast顯示的內文
 */
+ (void)showSectionIndexToastFromSuperView:(UIView*)superView withTitle:(NSString *)title;

/**
 * 隱藏section index toast
 */
+ (void)hideSectionIndexViewToast;



/**
 顯示一般訊息用的toast, size依內文決定，且會有自動內縮的效果，duration為1.0
 
 @param superView toast 的superview
 @param message toast顯示的內文
 @param messageTextAlignment 內文對齊方式
 @param duration 顯示的時間
 @param position 訊息顯示的位置
 */
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                 messageTextAlignment:(NSTextAlignment)messageTextAlignment
                             duration:(CGFloat)duration
                             position:(PPToastPosition)position;

/**
 * 顯示一般訊息用的toast, size依內文決定，且會有自動內縮的效果
 * @param superView toast 的superview
 * @param message toast顯示的內文
 * @param duration 顯示的時間
 * @param position 訊息顯示的位置
 */
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                             duration:(CGFloat)duration
                             position:(PPToastPosition)position;


/**
 顯示一般訊息用的toast, size依內文決定，且會有自動內縮的效果，duration為1.0
 
 @param superView toast 的superview
 @param message toast顯示的內文
 @param messageTextAlignment 內文對齊方式
 @param position 訊息顯示的位置
 */
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                 messageTextAlignment:(NSTextAlignment)messageTextAlignment
                             position:(PPToastPosition)position;


/**
 * 顯示一般訊息用的toast, size依內文決定，且會有自動內縮的效果，duration為1.0
 * @param superView toast 的superview
 * @param message toast顯示的內文
 * @param position 訊息顯示的位置
 */
+ (void)showMessageToastFromSuperView:(UIView*)superView
                          withMessage:(NSString*)message
                             position:(PPToastPosition)position;

/**
 * 隱藏一般訊息toast
 */
+ (void)hideMessageToast;


@end
