//
//  WCBaseTableViewController.h
//  WorldCardMobile7
//
//  Created by sanhue on 2015/7/8.
//  Copyright (c) 2015年 penpower. All rights reserved.
//


/**
 * WorldCardMobile的base table view，包含table view, seciton index view的控制
 * 資料由allCardSectionArray傳入，
 * 注意繼承的實作時，methods不可與這邊的一樣，不然會蓋掉原本的動作
 */
#import "PPViewController.h"

// models
#import "WCCardSectionModel.h"
#import "PPAppearance.h"

// views
#import "PPTableView.h"
#import "PPSectionIndexDefine.h"
#import "WCCardHolderCell.h"
#import "PPSectionIndexView.h"



////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol WCTableViewControllerProtocol <NSObject>

/**
 * 回傳cache中的縮圖給cell顯示
 */
- (UIImage *)cachedThumbnailImageWithCardID:(NSString *)cardID;

/**
 * 回傳名片縮圖給cell顯示
 */
- (UIImage *)thumbnailImageWithCardID:(NSString *)cardID;

@optional

/**
 * 取得目前名片的contactActionType
 * enableActionTypeInCell == YES時才會有效
 */
- (ContactActionType)contactActionTypeWithCardID:(NSString*)cardID;

/**
 * 如果有點擊cell中的action Type button會呼叫這個method
 * enableActionTypeInCell == YES時才會有效
 */
- (void)didClickCellActionType:(ContactActionType)Type withCardID:(NSString*)cardID;

/**
 * 如果有點擊cell中的action Type button會呼叫這個method
 * enableActionTypeInCell == YES時才會有效
 */
- (void)longPressActionButtonWithCell:(WCCardHolderCell *)cell;

/**
 * 如果有點擊cell中的action Type button會呼叫這個method
 * enableActionTypeInCell == YES時才會有效
 */
- (void)longPressWithCell:(WCCardHolderCell *)cell;

/**
 * 如果有點擊cell中的check button會呼叫這個method
 */
- (void)tableViewdidClickCheckButtonWithCell:(WCCardHolderCell *)cell;

/**
 * 如果cellType是WCCardHolderCellType_DuplicateWithOwner，WCCardHolderCellType_CompanyContactsWithOwner會呼叫這個來取得owner的名稱
 * 顯示到additionLabel
 */
- (NSString *)accountNameWithGuid:(NSString *)guid;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
@interface WCTableViewController : PPViewController
<
PPAppearance,
WCTableViewControllerProtocol,
UITableViewDelegate,
UITableViewDataSource
>

#pragma mark - ui instance access

/**
 * tableView實體
 */
@property (atomic, retain, readonly) PPTableView *tableView;

/**
 * sectionIndexView實體
 */
@property (atomic, retain, readonly) PPSectionIndexView *sectionIndexView;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - table view data

/**
 * WCCardSectionModel組成的array, 用來產生tableview cell
 */
@property (atomic, retain) NSMutableArray *allCardSectionArray;

/**
 * 用來取得名片資料的data controller, 繼承者需自行建立
 */
@property (atomic, retain) id dataController;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - attributes

/// 目前view controller使用的index mode
@property (nonatomic, assign, readonly) PPSIC_Mode mode;

/// 設定tableView 在沒有資料時的字串
@property (nonatomic, retain) NSString *noResultString;


/// 是否顯示section title, default YES;
@property (nonatomic, assign) BOOL showSectionTitle;

/// 是否顯示section index view, default YES;
@property (nonatomic, assign) BOOL showSectionIndexView;

/// YES: 第三個label顯示modified time, NO:顯示職稱，default NO;
@property (nonatomic, assign) BOOL cellShowModifiedTime;

/// tableview separator color setting, default gray
@property (nonatomic, retain) UIColor *separatorColor PP_APPEARANCE_SELECTOR;

/// 設定這個table使用的cell是什麼樣式
@property (nonatomic, assign) WCCardHolderCellType cellType;

/// 設定tableView的預設row height, default 72,
@property (nonatomic, assign) NSInteger defaultRowHeight;

/// 設定tableView 下方的footview height, default 0
@property (nonatomic, assign) CGFloat defaultFootViewHeight;

/// 預留的下面工具列空間，default 0
@property (nonatomic, assign) CGFloat reserveBottomToolbarSpace;

/// 是否開啟cell的長按功能，default NO, override時在init就要設定
@property (nonatomic, assign) BOOL enableLongPress;

/// monitor keyboard show/hide, default YES;
@property (nonatomic, assign) BOOL monitorKeyboardState PP_APPEARANCE_SELECTOR;

/// 用來紀錄目前table的contentoffset
@property (nonatomic, assign) CGPoint tableViewContentOffset;
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - reorder

/**
 * 是否開啟排序介面, default NO;
 */
@property (nonatomic, assign) BOOL enableReorderControl;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - multi-select

/**
 * 是否在多選模式, default NO;
 */
@property (nonatomic, assign) BOOL enableMultiSelectMode;

/**
 * 用來儲存被選取的cell
 */
@property (nonatomic, retain) NSMutableSet *multiSelectCardIDSet;


/**
 * 用來儲存被選取CardID與對應的CardModel, 方便快速找到cardModel
 */
@property (nonatomic, retain, readonly) NSMutableDictionary *multiSelectCardModelMapping;


/**
 * 依cardID選取一個cell，enableMultiSelectMode== YES時才有效
 * @param cardID 要選取的cell的名片ID
 */
- (void)selectCellWithCardID:(NSString *)cardID;

/**
 * 全選item時使用，enableMultiSelectMode== YES時才有效
 */
- (void)onSelectAll;

/**
 * 點擊到cell時使用，enableMultiSelectMode== YES時才有效
 */
- (void)onDidSelectCellWithIndexPath:(NSIndexPath *)indexPath;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - focus on cell

/// 顯示時是否要自動focus一個cell, 預設NO
@property (nonatomic, assign) BOOL autoFocusOneCell PP_APPEARANCE_SELECTOR;

/// 紀錄目前選取的cell的indexPath, 預設nil, 表示沒有選取
@property (nonatomic, retain) NSIndexPath *currentSelectedIndexPath;

/// 選取目前的名片, 會選取currentSelectedIndexPath所指到的cell, 如果cell不存在會清空currentSelectedIndexPath
- (void)selectCurrentCard;

/// 送出一個didSelect的訊息
- (void)activeCurrentSelectCell;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - methods

/// 繼承者如果要改寫init, 請複寫此api
- (instancetype)initWithMode:(PPSIC_Mode)mode;

/// 依據allCardSectionArray的個數決定要不要秀NoResult labal, 請在load 完data後call
- (void)showNoResultIfNeeded;

/// 從allCardSectonArray中移除CardModel
- (void)removeCardFromCardSectionArrayWithCardID:(NSString *)cardID;

/// 設定index mode
- (void)setIndexMode:(PPSIC_Mode)mode;

/// 取得所有ID
- (NSMutableArray *)cardIDArray;

/// 判斷indexPath是否合法
- (BOOL)validIndexPath:(NSIndexPath *)indexPath;
@end
