//
//  WCTRCContactUpdateInfoRequest.h
//
//  對應　Servre ContactUpdateVo
//
//  Created by Howard on 2016/3/17.
//
//

#import "WCTRestObject.h"

// Model
#import "WCTRCContactNameInfo.h"
#import "WCTRCContactJobInfo.h"
#import "WCTRCContactAddressInfo.h"
#import "WCTRCContactPhoneInfo.h"
#import "WCTRCContactMailInfo.h"
#import "WCTRCContactUrlInfo.h"
#import "WCTRCContactIMInfo.h"
#import "WCTRCContactSocialInfo.h"
#import "WCTRCContactCustomFieldData.h"
#import "WCTRCContactDateInfo.h"
#import "WCTRCContactUpdateInfoRequest.h"
#import "WCTRCSimpleCategoryInfo.h"

@interface WCTRCContactUpdateInfoRequest : WCTRestObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) NSString *contactGuid;
@property (nonatomic,retain) NSString *categoryOwnerAccountGuid;
@property (nonatomic,retain) NSArray *shareToAccountGuids; // The Array of NSString
@property (nonatomic,retain) NSArray *belongingCategories; // The Array of WCTRCSimpleCategoryInfo
@property (nonatomic,retain) NSString *frontImageFileGuid;
@property (nonatomic,retain) NSString *rearImageFileGuid;
@property (nonatomic,retain) NSString *logoImageFileGuid;
@property (nonatomic,retain) NSDate *displayModifyTime;     // 顯示的修改時間

@property (nonatomic,assign) NSInteger recogLanguageFront;
@property (nonatomic,assign) NSInteger recogLanguageBack;
@property (nonatomic,assign) BOOL beCorrected;

@property (nonatomic,retain) NSArray *names; // The WCTRCContactNameInfo of Array;
@property (nonatomic,retain) NSArray *jobinfos; // The WCTRCContactJobInfo of Array;
@property (nonatomic,retain) NSArray *addresses; // The WCTRCContactAddressInfo of Array;
@property (nonatomic,retain) NSArray *phones; // The WCTRCContactPhoneInfo of Array;
@property (nonatomic,retain) NSArray *emails; // The WCTRCContactMailInfo of Array;
@property (nonatomic,retain) NSArray *urls; // The WCTRCContactUrlInfo of Array;
@property (nonatomic,retain) NSArray *ims; // The WCTRCContactIMInfo of Array;
@property (nonatomic,retain) NSArray *socials; // The WCTRCContactSocialInfo of Array;
@property (nonatomic,retain) NSArray *dates; // The WCTRCContactDateInfo of Array;
@property (nonatomic,retain) NSArray *customFields; // The Array of WCTRCContactCustomFieldData;
@property (nonatomic,retain) NSDate *birthday;
@property (nonatomic,retain) NSString *nickname;
@property (nonatomic,retain) NSString *note;
@property (nonatomic,retain) NSString *uniformNumber;
@property (nonatomic,retain) NSArray *updateComponents; // The NSString of Array

@property (nonatomic,retain) NSDate *syncModifyTime;        // 同步用的修改時間

@end
