//
//  WCTSettingsDefine.h
//  Pods
//
//  Created by sanhue on 2016/4/26.
//
//

#ifndef WCTSettingsDefine_h
#define WCTSettingsDefine_h

////////////////////////////////////////////////////////////////////////////////////////////////////
// app settings

/// 啟用名片自動分享 , value: BOOL YES(1)，NO(0)
static NSString * const WCTSettingsKey_EnableBusinessCardAutoSharing = @"WCTSettingsKey_EnableCardAutoSharing";

/// 自動分享列表，value: ARRAY of guid string
static NSString * const WCTSettingsKey_BusinessCardSharingAccount = @"WCTSettingsKey_BusinessCardSharingAccount";

/// 幫忙掃描名片的帳號, value:  ARRAY of guid string
static NSString * const WCTSettingsKey_HelpScanningAccount = @"WCTSettingsKey_HelpScanningAccount";

/// salesforce login url
static NSString * const WCTSettingsKey_CRMLoginURL = @"WCTSettingsKey_CRMLoginURL";

/// CRM帳號, value: STRING of guid
static NSString * const WCTSettingsKey_CRMAccount = @"WCTSettingsKey_CRMAccount";

/// CRM匯出模式, value: STRING ，WCTRC_CRMExportMode_ContactSyncAuto，WCTRC_CRMExportMode_Manual
static NSString * const WCTSettingsKey_CRMExportMode = @"WCTSettingsKey_CRMExportMode";

/// CRM匯出指定帳號模式, value: STRING ，WCTRC_CRMCompanyAssignmentOption_Manul，WCTRC_CRMCompanyAssignmentOption_Auto，WCTRC_CRMCompanyAssignmentOption_None
static NSString * const WCTSettingsKey_CRMCompanyAssignmentOption = @"WCTSettingsKey_CRMCompanyAssignmentOption";

/// Exchange類型, value: STRING of guid
static NSString * const WCTSettingsKey_ExchangeType = @"WCTSettingsKey_ExchangeType";

/// Exchange帳號, value: STRING
static NSString * const WCTSettingsKey_ExchangeAccount = @"WCTSettingsKey_ExchangeAccount";

/// Exchange匯出模式, value: STRING ，WCTRC_ExportMode_ContactSyncAuto，WCTRC_ExportMode_Manual
static NSString * const WCTSettingsKey_ExchangeExportMode = @"WCTSettingsKey_ExchangeExportMode";


/// 全公司共享，value: BOOL, YES(1), NO(0)
static NSString * const WCTSettingsKey_GlobalShareToCompany = @"WCTSettingsKey_GlobalShareToCompany";

/// server 資料庫建立時間，value: DateTime
static NSString * const WCTSettingsKey_ServerDBBuildTime = @"WCTSettingsKey_ServerDBBuildTime";

/// Server試用到期日，nil代表正式版無日期限制。
static NSString * const WCTSettingsKey_ServerValidateDate = @"WCTSettingsKey_ServerValidateDate";



////////////////////////////////////////////////////////////////////////////////////////////////////
// account info

/// 帳號ID, value: STRING of guid
static NSString * const WCTSettingsKey_AccountGUID = @"WCTSettingsKey_AccountGUID";

/// 伺服器ID, value: STRING of server guid
static NSString * const WCTSettingsKey_ServerGUID = @"WCTSettingsKey_ServerGUID";

/// 帳號匯出能力，value: BOOL, YES(1), NO(0)
static NSString * const WCTSettingsKey_ExportAbility = @"WCTSettingsKey_ExportAbility";

/// 帳號幫忙掃描能力，value: BOOL, YES(1), NO(0)
static NSString * const WCTSettingsKey_HelpScanningAbility = @"WCTSettingsKey_HelpScanningAbility";

/// 帳號列印能力，value: BOOL, YES(1), NO(0)
static NSString * const WCTSettingsKey_PrintAbility = @"WCTSettingsKey_PrintAbility";

/// 帳號角色, value: STRING ,  WCTRC_Role_Admin, WCTRC_Role_NormalUser, WCTRC_Role_ReadOnlyUser
static NSString * const WCTSettingsKey_AccountRole = @"WCTSettingsKey_AccountRole";

/// 帳號類型，value: BOOL, YES, if is ADAccount
static NSString * const WCTSettingsKey_IsADAccount = @"WCTSettingsKey_IsADAccount";

/// 主管guid, value: STRING of guid
static NSString * const WCTSettingsKey_BossAccountGUID = @"WCTSettingsKey_BossAccountGUID";

/// 我的最愛類別guid, value: STRING of guid
static NSString * const WCTSettingsKey_FavoriteCategoryGUID = @"WCTSettingsKey_FavoriteCategoryGUID";

/// 帳號最大可用的聯絡人數量，超過就無法同步
static NSString * const WCTSettingsKey_MaxPrivateContactCount = @"WCTSettingsKey_MaxPrivateContactCount";

/// 帳號最大公有區聯絡人數量，超過就無法同步
static NSString * const WCTSettingsKey_MaxPublicContactCount = @"WCTSettingsKey_MaxPublicContactCount";

/// 系統最大聯絡人總筆數，超過就無法同步
static NSString * const WCTSettingsKey_MaxServerContactCount = @"WCTSettingsKey_MaxServerContactCount";



////////////////////////////////////////////////////////////////////////////////////////////////////
// time filter

/// 過濾時間的條件
typedef NS_ENUM(NSUInteger, WCTTimeFilter)
{
    WCTTimeFilter_All = 0,
    WCTTimeFilter_Today,
    WCTTimeFilter_Yesterday,
    WCTTimeFilter_Latest3Days,
    WCTTimeFilter_LatestWeek,
    WCTTimeFilter_LatestMonth,
};

/// 記錄過濾時間的條件, value: WCTTimeFilter
static NSString * const WCTSettingsKey_TimeFilter = @"WCTSettingsKey_TimeFilter";


/// 是否顯示匯出/分享
static NSString * const WCTSettingsKey_ShowExportUI =@"WCTSettingsKey_ShowExportUI";
/// 是否顯示MyCard
static NSString * const WCTSettingsKey_ShowMyCardUI =@"WCTSettingsKey_ShowMyCardUI";
/// 是否顯示CRM設定
static NSString * const WCTSettingsKey_ShowCrmUI =@"WCTSettingsKey_ShowCrmUI";
/// 是否顯示公司通訊錄設定
static NSString * const WCTSettingsKey_ShowContactServerUI =@"WCTSettingsKey_ShowContactServerUI";

#endif /* WCTSettingsDefine_h */
