//
//  WCTDataControllerProtocol.h
//  Pods
//
//  Created by sanhue on 2016/7/25.
//
//

#import <Foundation/Foundation.h>



// !!  為了避免與WCTDataModel/Model有相依性，所以這邊用@class來定義model
@class WCTCardSyncActionModel;
@class WCTGroupSyncActionModel;
@class WCTAccountRelationModel;

////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol WCTDataControllerProtocol_Card;
@protocol WCTDataControllerProtocol_Group;
@protocol WCTDataControllerProtocol_SystemGuid;
@protocol WCTDataControllerProtocol_AccountList;
@protocol WCTDataControllerProtocol_SharedAccount;
@protocol WCTDataControllerProtocol_GroupSyncAction;
@protocol WCTDataControllerProtocol_CardImportedIDMapping;
@protocol WCTDataControllerProtocol_CardSyncAction;
@protocol WCTDataControllerProtocol_CardImageSHA1;

////////////////////////////////////////////////////////////////////////////////////////////////////
@protocol WCTDataControllerProtocol
<
WCTDataControllerProtocol_Card,
WCTDataControllerProtocol_Group,
WCTDataControllerProtocol_SystemGuid,
WCTDataControllerProtocol_AccountList,
WCTDataControllerProtocol_SharedAccount,
WCTDataControllerProtocol_CardImportedIDMapping,
WCTDataControllerProtocol_GroupSyncAction,
WCTDataControllerProtocol_CardSyncAction,
WCTDataControllerProtocol_CardImageSHA1
>
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCT Group

@protocol WCTDataControllerProtocol_Group <NSObject>

/// 新增類別並更新syncActionModel
- (WCGroupModel *)newGroupWithName:(NSString *)groupName syncActionModel:(WCTGroupSyncActionModel *)syncActionModel;

// 新增群組(同步的時候才使用，同步的時候若要新增群組，就忽略掉群組名稱重複的問題)
// return : WCGroupModel (release after using)
- (WCGroupModel *)newGroupWithNameForSync:(NSString *)groupName;

/// 同步用，新增類別並更新syncActionModel，不會檢查是否重複
- (WCGroupModel *)newGroupWithNameForSync:(NSString *)groupName syncActionModel:(WCTGroupSyncActionModel *)syncActionModel;

/// 鄤除類別並更新syncActionModel
- (BOOL)removeGroupWithID:(WC_GroupID)groupID syncActionModel:(WCTGroupSyncActionModel *)syncActionModel;

/**
 * 刪除群組 (Sync) 不會更新groupOrderModifiedTime
 * @param groupID NSString 群組ID，WCM, WCT要把WC_GroupID轉成string後塞進來
 * @return BOOL YES:成功；NO:失敗
 */
- (BOOL)removeGroupWithIDForSync:(NSString *)groupID;

/// 更新群組名稱並更新syncActionModel
- (BOOL)updateGroupName:(NSString *)groupName withID:(NSInteger)groupID syncActionModel:(WCTGroupSyncActionModel *)syncActionModel;

// 更新group guid
- (BOOL)updateGroupGuid:(NSString *)guid withID:(NSInteger)groupID;

// 取得群組ID
- (WC_GroupID)groupIDWithGuid:(NSString *)groupGuid;

// 取得群組名稱
- (NSString *)groupNameWithGuid:(NSString *)groupGuid;

// 取得group完整資訊
- (WCGroupModel *)groupWithGuid:(NSString *)groupGuid;

// 取得和groupID和groupGuid對照表 Key:@(groupID)
- (NSDictionary *)groupIDAndGuidMappingDict;
@end



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCT Card

@protocol WCTDataControllerProtocol_Card <NSObject>

/**
 新增名片並更新syncActionModel

 @param cardModel 要新增的內容
 @param syncActionModel 同步用資料
 @param sendNotification 是否發送通知
 @return YES表示更新成功；NO表示失敗，失敗原因從lastError取得。
 */
- (BOOL)addCard:(WCCardModel *)cardModel syncActionModel:(WCTCardSyncActionModel*)syncActionModel withSendNotification:(BOOL)sendNotification;


/**
 更新名片資料

 @param cardModel 要更新的內容
 @param sendNotification 是否發送通知
 @param syncActionModel 同步紀錄要更新的內容
 @param mustExist 是否要存在才能更新
 @return YES表示更新成功；NO表示失敗，失敗原因從lastError取得。
 */
- (BOOL)updateCard:(WCCardModel *)cardModel withSendNotification:(BOOL)sendNotification syncActionModel:(WCTCardSyncActionModel *)syncActionModel mustExist:(BOOL)mustExist;


/**
 同步，更新時的刪除名片動作 (For Sync)

 @param cardID 要刪除的名片ID
 @return YES表示更新成功；NO表示失敗，失敗原因從lastError取得。
 */
- (BOOL)removeCardDataForSyncUpdate:(NSString *)cardID;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - SystemGuid

@protocol WCTDataControllerProtocol_SystemGuid <NSObject>
/// 儲存預設群組的guid，目前只有WC_GID_All, WC_GID_Unfiled可以用
- (BOOL)setDefaultGroupGuid:(NSString *)groupGuid withGroupID:(WC_GroupID)groupID;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - AccountList

@protocol WCTDataControllerProtocol_AccountList <NSObject>

/// 取得所有帳號 (不包含離職), 與[self copyAllAccountListWithResign:NO]的結果相同
- (NSMutableArray *)copyAllAccountList;

/**
 * 取得所有帳號
 * @param resign YES: 包含離職；NO，不包含離職
 * @return array of WCTAccountRelationModel
 */
- (NSMutableArray *)copyAllAccountListWithResign:(BOOL)resign;

/**
 * 取得所有最近繫繫聯絡人
 * @return BOOL YES if success, else failed
 */
- (BOOL)updateAllAccountWithList:(NSArray *)list;

/**
 * 取得account releation
 * @param accountGuid account guid
 * @return WCTAccountRelationModel account relation
 */
- (WCTAccountRelationModel *)accountRelationWithAcountGuid:(NSString *)accountGuid;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - SharedAccount

@protocol WCTDataControllerProtocol_SharedAccount <NSObject>

/// 取得可檢視聯絡人資料
- (NSMutableArray *)copySharedAccountWithCardID:(NSString *)cardID;

/// 設定可檢視聯絡人資料
- (BOOL)setCardSharedAccountGuids:(NSArray *)sharedAccountGuids withCardID:(NSString *)cardID;

/// 設定可檢視聯絡人資料，多選一定要用這個
- (BOOL)setCardSharedAccountGuids:(NSArray *)sharedAccountGuids withCardIDs:(NSArray *)cardIDs;
@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - GroupSyncAction

@protocol WCTDataControllerProtocol_GroupSyncAction <NSObject>

/**
 * Get group sync actions(只取出SyncAction不是None的)
 *
 * @return Array of WCTGroupSyncActionModel
 */
- (NSMutableArray *)copyGroupSyncActions;

/**
 * Get group sync actions
 *
 * @param date - 取得資料的時間條件，nil代表全部。
 * @return Array of WCTGroupSyncActionModel
 */
- (NSMutableArray *)copyGroupSyncActionsAfterDate:(NSDate *)date;


/**
 * get group sync action record
 *
 * @param groupGuid - 分類的GUID
 * @return WCTGroupSyncActionModel group sync action, or nil if failed
 */
- (WCTGroupSyncActionModel *)copyGroupSyncActionModelWithGuid:(NSString *)groupGuid;


/**
 * Remove group sync action record
 *
 * @param groupGuid - 分類的GUID
 * @return YES if remove success
 */
- (BOOL)removeGroupSyncActionWithGuid:(NSString *)groupGuid;


/**
 * 更新群組動作的修改時間
 *
 * @param modifiedTime 動作修改時間
 * @param guid - group guid
 * @return YES if success
 */
- (BOOL)updateGroupModifiedTime:(NSDate *)modifiedTime withGuid:(NSString *)guid;


/**
 * 重設群組動作為None
 *
 * @param guid - group guid
 * @return YES if success
 */
- (BOOL)resetGroupSyncActionToNoneWithGuid:(NSString *)guid;
@end



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - imported card id mapping

@protocol WCTDataControllerProtocol_CardImportedIDMapping <NSObject>

/// 以舊cardID查詢GUID
- (NSString *)cardIDWithImportedCardID:(NSString *)importedCardID;

/// 設定舊的cardID與GUID的mapping
- (BOOL)setImporedCardID:(NSString *)importedCardID withCardID:(NSString *)cardID;

/// 移除mapping
- (BOOL)removeImportedCardIDWithCardID:(NSString *)cardID;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CardSyncAction

@protocol WCTDataControllerProtocol_CardSyncAction <NSObject>

/**
 * Get card sync actions(只取出SyncAction不是None的)
 *
 * @return Array of WCTGroupSyncActionModel
 */
- (NSMutableArray *)copyCardSyncActions;

/**
 * Get card sync actions
 *
 * @param date - 取得資料的時間條件，nil代表全部。
 * @return Array of WCTCardSyncActionModel
 */
- (NSMutableArray *)copyCardSyncActionsAfterDate:(NSDate *)date;

/**
 * Get card sync action
 *
 * @param cardID - 取得資料的名片ID
 * @return WCTCardSyncActionModel card sync action model, or nil if failed
 */
- (WCTCardSyncActionModel *)copyCardSyncActionModelWithCardID:(NSString *)cardID;


/**
 * Remove card sync action record
 *
 * @param cardID - 名片ID
 * @return YES if remove success
 */
- (BOOL)removeCardSyncActionWithCardID:(NSString *)cardID;


/**
 * 更新名片同步資料
 *
 * @param syncActionModel 名片同步資料
 * @param checkModifyTime 用來檢查同步紀錄是否被修改，nil表示不檢查直接寫入
 * @return YES if success
 */
- (BOOL)updateCardSyncAction:(WCTCardSyncActionModel *)syncActionModel withCheckModifyTime:(NSDate *)checkModifyTime;


/**
 * 更新名片動作的修改時間
 *
 * @param syncAcctinoModifiedTime 動作修改時間
 * @param cardID - 名片ID
 * @return YES if success
 */
- (BOOL)updateCardSyncActionModifiedTime:(NSDate *)syncAcctinoModifiedTime withCardID:(NSString *)cardID;


/**
 * 重設名片動作為None
 *
 * @param cardID - 名片ID
 * @param checkModifyTime 檢查sync action時間是否已修改過
 * @return YES if success
 */
- (BOOL)resetCardSyncActionToNoneWithCardID:(NSString *)cardID checkModifyTime:(NSDate *)checkModifyTime;


/**
 * 更換guid
 * @param oldGuid 要被更換的guid
 * @param newGuid 要換成什麼guid
 
 * @return BOOL YES if success
 */
- (BOOL)replaceGuidFromOld:(NSString *)oldGuid toNew:(NSString *)newGuid;

/**
 * 檢查傳入的guid列表是否都同步到server上過
 * @param guids guid list
 * @return BOOL YES: 全部都同步過，NO: 有至少一筆沒有同步過
 */
- (BOOL)isCardSyncedWithGuids:(NSArray *)guids;

/// 清除資料庫中不合法的記錄，如WCCard中有記錄，但WCTCardSyncAction中沒有；或WCTCardSyncAction中有資料但WCCard中沒有
- (void)fixInvalidRecord;

@end


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - CardImageSHA1

@protocol WCTDataControllerProtocol_CardImageSHA1 <NSObject>

/**
 * 比對傳入的Sha1是否與手機上的相同
 * @param imageSha1 要用來比對的sha1
 * @param cardID 比對目標的CardID
 * @param type 比對目標的type
 * @return BOOL YES: 與比對目標相同，空字串與Empty一樣；NO與比對目標不同
 */
- (BOOL)isImageSha1:(NSString *)imageSha1 equalWithCardID:(NSString *)cardID  type:(WC_ImageType)type;

/**
 * 設定名片圖並更新SHA1
 *
 * @param image - 名片圖
 * @param imageSHA1 - 名片圖SHA1
 * @param cardID - 名片ID
 * @param type - image type
 *
 * @return YES if success
 */
- (BOOL)setCardImage:(CPImage *)image imageSHA1:(NSString *)imageSHA1 withCardID:(NSString *)cardID type:(WC_ImageType)type;

/**
 * 設定名片圖並更新SHA1
 *
 * @param imageData - 名片圖的NSData
 * @param imageSHA1 - 名片圖SHA1
 * @param cardID - 名片ID
 * @param type - image type
 *
 * @return YES if success
 */
- (BOOL)setCardImageData:(NSData *)imageData imageSHA1:(NSString *)imageSHA1 withCardID:(NSString *)cardID type:(WC_ImageType)type;
@end
