//
//  WCCardDBController.h
//  WorldCardHD
//
//  Created by  Eddie on 2011/1/5.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPSQLiteDBController.h"

// defines
#import "WCImageDefine.h"
#import "WCTCardDBDefine.h"
#import "WCTagMaskDefine.h"

// models
#import "WCABCardModel.h"
#import "WCCardModel.h"
#import "WCDuplicateCompareModel.h"
#import "WCGroupModel.h"
#import "WCRecentCardModel.h"
#import "WCTCardSyncActionModel.h"
#import "WCTGroupSyncActionModel.h"
#import "WCTAccountRelationModel.h"
#import "WCCustomFieldInfo.h"
#import "WCCustomFieldListItem.h"
#import "WCTAdvancedSearchModel.h"

// controllers
#import "WCToolController.h"

////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTCardDBController : PPSQLiteDBController
{
    NSString *dirPath_;
    BOOL isCancelDBAction_;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle methods

/**
 Get shared instance

 @param dbPath sharedInstance連接的資料庫路徑。輸入不同路徑會切換連結的資料庫，nil代表取得目前instance不變更路徑。
 @return WCTCardDBController shared instance
 */
+ (WCTCardDBController *)sharedWCTCardDBControllerWithDBPath:(NSString *)dbPath;

/**
 Initialize

 @param dirPath 資料夾路徑
 @param dbName 資料庫名稱
 @return WCTCardDBController instance
 */
- (id)initWithDirPath:(NSString *)dirPath dbName:(NSString *)dbName;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Database methods

- (BOOL)createDB;
- (BOOL)connectDB;
- (void)disconnectDB;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - check db methods

- (BOOL)isTableExist:(NSString *)tableName withSynchronized:(BOOL)synchronized;
- (BOOL)isIndexExist:(NSString *)indexName withSynchronized:(BOOL)synchronized;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Info methods

- (NSString *)infoValueWithKey:(NSString *)infoKey;
- (BOOL)addInfoValue:(NSString *)infoValue withKey:(NSString *)infoKey;
- (BOOL)updateInfoValue:(NSString *)infoValue withKey:(NSString *)infoKey;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Favorite methods

- (NSMutableArray *)copyAllFavorites;
- (NSMutableArray *)copyFavoritesWithSearchText:(NSString *)searchText;
- (NSInteger)favoriteOrderWithCardID:(NSString *)cardID;
- (BOOL)addFavoriteWithCardID:(NSString *)cardID isInTransaction:(BOOL)isInTransaction;
- (BOOL)insertFavoriteWithCardID:(NSString *)cardID toOrder:(NSInteger)toOrder;
- (BOOL)removeFavoriteWithCardID:(NSString *)cardID isInTransaction:(BOOL)isInTransaction;
- (BOOL)moveFavoriteWithCardID:(NSString *)cardID toOrder:(NSInteger)toOrder;

/// iOS版7.0 加入我的最愛的action Type
- (void)setActionType:(NSInteger)actionType withCardID:(NSString *)cardID;

/// iOS版7.0 取得我的最愛的action Type
- (NSInteger)actionTypeWithCardID:(NSString *)cardID;

/// macOS版4.0 取得我的最愛的數量
- (NSInteger)favoriteCount;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Unverified methods

- (NSMutableArray *)copyAllUnverified;
- (NSMutableArray *)copyUnverifiedWithSearchText:(NSString *)searchText;
- (BOOL)addUnverifiedWithCardID:(NSString *)cardID;
- (BOOL)removeUnverifiedWithCardID:(NSString *)cardID;
- (BOOL)isUnverifiedWithCardID:(NSString *)cardID;
- (NSInteger)unverifiedCount;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Group methods

- (NSMutableArray *)copyAllGroups;
- (BOOL)addGroupWithName:(NSString *)groupName ID:(NSInteger)groupID guid:(NSString *)guid superGroupGuid:(NSString *)superGroupGuid helper:(NSString *)helper;
- (NSString *)groupNameWithID:(NSInteger)groupID;
- (NSDate *)groupModifiedTimeWithID:(NSInteger)groupID;

/// WCT新增
- (NSString *)groupGuidWithID:(WC_GroupID)groupID;
- (NSString *)groupHelperWithID:(WC_GroupID)groupID;

/// category order modified time
- (NSDate *)groupOrderModifiedTime;
- (void)setGroupOrderModifiedTime:(NSDate *)groupOrderModifiedTime;
- (void)removeGroupOrderModifiedTime;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Card-Group methods

- (BOOL)setCardGroupsWithCardID:(NSString *)cardID groupIDArray:(NSArray *)groupIDArray isInTransaction:(BOOL)isInTransaction updateModifiedTIme:(BOOL)updateModifiedTIme;
- (NSInteger)cardCountOfGroup:(NSInteger)groupID;
- (NSMutableArray *)copyGroupIDArrayWithCardID:(NSString *)cardID;
- (NSMutableArray *)copyCardIDArrayWithGroupID:(NSInteger)groupID;//wcm6.0

/// 7.0 取得google 預設群組的聯絡人個數
- (NSInteger)cardCountForGoogleGroup;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Field methods

/// public for inher
- (BOOL)insertFieldWithCardID:(NSString *)cardID fieldModel:(WCFieldModel *)fieldModel;

- (NSMutableArray *)copyFieldValueArrayWithCardIDArray:(NSArray *)cardIDArray fieldType:(WC_FieldType)fieldType;
- (NSMutableArray *)copyPhoneArrayWithCardIDArray:(NSArray *)cardIDArray;
- (NSMutableArray *)copyPhoneArrayForSendMessageWithCardIDArray:(NSArray *)cardIDArray;
- (NSInteger)fieldCountWithCardID:(NSString *)cardID;

/// 7.0 新增
/// 取得note
- (NSString *)noteWithCardID:(NSString *)cardID;

/// 更新note
- (BOOL)updateNote:(NSString *)note withCardID:(NSString *)cardID;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Card methods

- (NSInteger)totalCardCount;
- (NSInteger)totalTwoSideCardCountWithSourceID:(WC_SourceID)sourceID;
- (BOOL)insertCard:(WCCardModel *)cardModel isImportMode:(BOOL)isImportMode __deprecated;
- (BOOL)removeCardWithCardID:(NSString *)cardID __deprecated;
- (WCCardModel *)copyCardWithCardID:(NSString *)cardID getAllField:(BOOL)getAllField;
- (NSDate *)cardModifiedTimeWithCardID:(NSString *)cardID;
- (BOOL)updateCardModifiedTime:(NSDate *)modifiedTime withCardID:(NSString *)cardID;
- (BOOL)isCardExist:(WCCardModel *)cardModel;
- (BOOL)isCardIDExist:(NSString *)cardID;
- (NSArray *)copyEmptyCardID;
- (void)updateOrderToFirstWithIndex:(NSInteger)index withCardID:(NSString *)cardID fieldType:(NSInteger)fieldType;
- (NSMutableArray *)copyAllCardsWithGroupID:(NSInteger)groupID searchText:(NSString *)searchText;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Change display rule methods

- (NSMutableArray *)copyAllCardsForChangeDisplayRule;
- (BOOL)updateAllCardsForChangeDisplayRule:(NSArray *)cardArray;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Duplicate check methods

/// sameNameOnly==YES, 只找同名
- (NSMutableArray *)copyDuplicateCardsWithSameNameOnly:(BOOL)sameNameOnly;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Cancel methods

- (void)cancel;
- (void)clearCancelFlag;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Other methods

- (BOOL)updateModifiedTimeWithCardID:(NSString *)cardID;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Check and recover methods

/// 取得讀音有錯的欄位
- (NSMutableArray *)copyAllInvalidPhoneticFieldIDWithFieldSubType2:(NSInteger)fieldSubType2;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - WCM 7.0.0 new method
#pragma mark - address book methods

/// 利用PersonID查詢cardID
- (NSString *)cardIDWithABPersonID:(NSString *)abPersonID;

/// 加入 address book data, 只會更新WCAddressBookMapping
- (BOOL)updateAddressBookDataWithCardModel:(WCABCardModel *)cardModel;

/// 刪除addressbook data
- (BOOL)removeAddressBookDataWithCardID:(NSString *)cardID;

/// 取得address book data, 只會更新abPersonID, abSourceID, abGroupID
- (BOOL)getAddressBookDataWithCardModel:(WCABCardModel *)abCardModel;

/// 清除所有address book資料，還原時使用
- (BOOL)clearAddressBookData;

/// 取得所有address book資料，同步時使用
- (NSArray *)allAddressBookData;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - AddressBook convert to Contacts framework methods

/**
 * 取得全部有AddressBook mapping的名片ID
 * @return card id array
 */
- (NSArray <NSString *>*)allCardIDFromAddressBookMapping;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - recent contact methods

/// 加入最近連繫聯絡人
- (BOOL)insertRecentAction:(NSInteger)action withContent:(NSString *)content cardID:(NSString *)cardID;

/// 刪除最近聯繫聯僧人
- (BOOL)removeRecentActionWithCardID:(NSString *)cardID;

/**
 * 取得所有最近繫繫聯絡人
 * @return NSMutableArray array of WCRecentCardModel, 只有action Type, action content, action time, cardID
 */
- (NSMutableArray *)copyAllRecentContacts;

/// 清除最近連繫聯絡人
- (BOOL)clearRecentContactData;

/// 是否有最近聯繫聯絡人
- (BOOL)hasRecentContacts;










////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - 以下為WCT新增或調整函式
////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Account list methods

/**
 * 取得所有帳號
 * @param resign YES: 包含離職；NO，不包含離職
 * @return array of WCTAccountRelationModel
 */
- (NSMutableArray *)copyAllAccountListWithResign:(BOOL)resign;


/// 取得所有最近繫繫聯絡人
- (BOOL)updateAllAccountWithList:(NSArray *)list;

/**
 * 取得account releation
 * @param accountGuid account guid
 * @return WCTAccountRelationModel account relation
 */
- (WCTAccountRelationModel *)accountRelationWithAcountGuid:(NSString *)accountGuid;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Shared account methods

/// 取得可檢視聯絡人資料
- (NSMutableArray *)copySharedAccountWithCardID:(NSString *)cardID;

// 設定可檢視用戶
- (BOOL)setCardSharedAccountGuids:(NSArray *)sharedAccountGuids withCardID:(NSString *)cardID isInTransaction:(BOOL)isInTransaction updateModifiedTime:(BOOL)updateModifiedTime;

// 設定可檢視用戶，一般操作請用這個
- (BOOL)setCardSharedAccountGuids:(NSArray *)sharedAccountGuids withCardID:(NSString *)cardID;

// 設定可檢視用戶，一次設定多筆名片的可檢視用戶, 多選時請一定要用這個，不然效率會不好
- (BOOL)setCardSharedAccountGuids:(NSArray *)sharedAccountGuids withCardIDs:(NSArray *)cardIDs;





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Custom field

/**
 * 取得所有自訂欄位資料
 * @return NSMutableArray array of WCCustomFieldInfo
 */
- (NSMutableArray *)copyAllCustomFieldInfos;

/// 依自訂欄位guid, 取得自訂欄位資料
- (WCCustomFieldInfo *)customFieldInfoWithGuid:(NSString *)guid;

/// 新增一個自訂欄位資料
- (BOOL)addCustomFieldWithInfo:(WCCustomFieldInfo *)customFieldInfo;

/// 如果已存在，就更新，如果不存在就新增
- (BOOL)updateCustomFieldWithInfo:(WCCustomFieldInfo *)customFieldInfo;

/// 移除一個自訂欄位
- (void)removeCustomFieldWithGuid:(NSString *)guid;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Group methods

- (NSInteger)groupIDWithGuid:(NSString *)groupGuid;

- (NSString *)groupNameWithGuid:(NSString *)groupGuid;

- (BOOL)updateGroupGuid:(NSString *)guid withID:(NSInteger)groupID;

- (BOOL)updateSuperGroupGuid:(NSString *)superGroupGuid withID:(NSInteger)groupID;

/// 清除所有釘選order, 更新pinned order時使用
- (BOOL)clearAllGroupPinnedOrder;

- (BOOL)updateGroupPinnedOrder:(NSInteger)pinnedOrder withGuid:(NSString *)groupGuid;

- (NSMutableArray *)pinnedGroups;

- (WCGroupModel *)groupWithGuid:(NSString *)groupGuid;

/// Key:@(groupID)
- (NSDictionary *)groupIDAndGuidMappingDict;

/// 取得某名片的所有群組
- (NSArray *)copyGroupGuidArrayWithCardID:(NSString *)cardID;

/// 以名稱新增類別，並更新groupSyncActionModel
- (WC_GroupID)addGroupWithName:(NSString *)groupName syncActionModel:(WCTGroupSyncActionModel *)syncActionModel;

- (BOOL)removeGroupWithID:(WC_GroupID)groupID syncActionModel:(WCTGroupSyncActionModel *)syncActionModel;

- (BOOL)updateGroupName:(NSString *)groupName withID:(NSInteger)groupID syncActionModel:(WCTGroupSyncActionModel *)syncActionModel;

- (BOOL)updateOrderWithGroupIDArray:(NSArray<NSString *> *)groupIDArray;

- (BOOL)updateGroupHelper:(NSString *)helper withID:(NSInteger)groupID;

/// 指定刪除群組後沒有分類名片要歸類到哪個群組，預設是Unfiled。
- (void)setMustHaveGroupIDAfterRemoveGroup:(WC_GroupID)groupID;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Group sync action methods

/// 取得SyncAction不是None的紀錄
- (NSMutableArray *)copyGroupSyncActions;

/// 取得date之後的所有動作列表
- (NSMutableArray *)copyGroupSyncActionsAfterDate:(NSDate *)date;

/// 依groupGuid，取得動作資料
- (WCTGroupSyncActionModel *)copyGroupSyncActionModelWithGuid:(NSString *)groupGuid;

/// 依groupGuid，刪除動作資料
- (BOOL)removeGroupSyncActionWithGuid:(NSString *)groupGuid;
    
/// 更新GroupSyncActoin
- (BOOL)updateGroupSyncAction:(WCTGroupSyncActionModel *)groupSyncAction;

/// 更新群組動作的修改時間
- (BOOL)updateGroupModifiedTime:(NSDate *)modifiedTime withGuid:(NSString *)guid;

/// 重設動作為None
- (BOOL)resetGroupSyncActionToNoneWithGuid:(NSString *)guid;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Card methods

///
- (BOOL)insertCard:(WCCardModel *)cardModel syncActionModel:(WCTCardSyncActionModel *)syncActionModel isImportMode:(BOOL)isImportMode isInTransaction:(BOOL)isInTransaction;

/**
 * 更新流程與cardDB有關的放到元件中，方便做synchronized與transaction管理
 * @param cardModel 要更新的名片內容
 * @param syncActionModel 更新後syncActionModel要設定的內容，nil表示不更新
 * @param mustExist YES:名片存在才能更新，NO，不存在時會直接新增
 * @return BOOL 是否更新成功
 */
- (BOOL)updateCard:(WCCardModel *)cardModel syncActionModel:(WCTCardSyncActionModel *)syncActionModel mustExist:(BOOL)mustExist;

///
- (BOOL)removeCardWithCardID:(NSString *)cardID syncActionModel:(WCTCardSyncActionModel*)syncActionModel;

/// updateCard時，forUpdate要設為YES
/**
 * updateCard時，forUpdate要設為YES
 * @param cardID 要刪除的名片ID
 * @param syncActionModel dirty table要設定的值
 * @param forUpdate updateCard中使用這個API時要設為YES，設為NO時，如果syncActionModel==nil,會把dirty table刪掉
 * @param isInTransaction 是否在transation中使用
 * @return BOOL 是否刪除成功
 */
- (BOOL)removeCardWithCardID:(NSString *)cardID syncActionModel:(WCTCardSyncActionModel*)syncActionModel forUpdate:(BOOL)forUpdate isInTransaction:(BOOL)isInTransaction;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - imported card id mapping

/// 以舊cardID查詢GUID
- (NSString *)cardIDWithImportedCardID:(NSString *)importedCardID;

/// 設定舊的cardID與GUID的mapping
- (BOOL)setImporedCardID:(NSString *)importedCardID withCardID:(NSString *)cardID;

/// 移除mapping
- (BOOL)removeImportedCardIDWithCardID:(NSString *)cardID;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Card sync action methods

/// 取得SyncAction不是None的紀錄
- (NSMutableArray *)copyCardSyncActions;

/// 取得date之後的所有動作列表
- (NSMutableArray *)copyCardSyncActionsAfterDate:(NSDate *)date;

/// 依CardID，取得動作資料
- (WCTCardSyncActionModel *)copyCardSyncActionModelWithCardID:(NSString *)cardID;

/// 依CardID，刪除動作資料
- (BOOL)removeCardSyncActionWithCardID:(NSString *)cardID;

/**
 * 更新名片同步資料
 * @param cardSyncAction 要寫入的同步資料
 * @param checkModifyTime 用來檢查syncAction是否有修改
 * @param isInTransaction 是否在transaction中
 * @return BOOL 是否更新成功
 */
- (BOOL)updateCardSyncAction:(WCTCardSyncActionModel *)cardSyncAction withCheckModifyTime:(NSDate *)checkModifyTime isInTransaction:(BOOL)isInTransaction;

/// 更新名片同步資料
- (BOOL)updateCardSyncAction:(WCTCardSyncActionModel *)cardSyncAction isInTransaction:(BOOL)isInTransaction;

/// 更新名片同步資料的修改時間
- (BOOL)updateCardSyncActionModifiedTime:(NSDate *)modifiedTime withCardID:(NSString *)cardID;

/// 重設名片同步動作為None
- (BOOL)resetCardSyncActionToNoneWithCardID:(NSString *)cardID checkModifyTime:(NSDate *)checkModifyTime;

/// 更新名片”群組“時的syncAction調整
- (BOOL)updateCardSyncActionForGroupChangeWithCardID:(NSString *)cardID modifiedTime:(NSDate *)modifiedTime;

/// 更新名片”可檢視用戶“時的syncAction調整
- (BOOL)updateCardSyncActionForSharedAccountChangeWithCardID:(NSString *)cardID modifiedTime:(NSDate *)modifiedTime;

/// 更新名片”內容“時的syncAction調整
- (BOOL)updateCardSyncActionForContentChangeWithCardID:(NSString *)cardID modifiedTime:(NSDate *)modifiedTime;

/// 更新名片”影像“時的syncAction調整
- (BOOL)updateCardSyncActionForImageChangeWithCardID:(NSString *)cardID imageType:(WC_ImageType)imageType modifiedTime:(NSDate *)modifiedTime;


/// 更換guid
- (BOOL)replaceGuidFromOld:(NSString *)oldGuid toNew:(NSString *)newGuid;

/// 檢查是否已同步過
- (BOOL)isCardSyncedWithGuid:(NSString *)guid;

/// 修正資料庫中不合法的記錄，如WCCard中有記錄，但WCTCardSyncAction中沒有；或WCTCardSyncAction中有資料但WCCard中沒有
- (void)fixInvalidRecord;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Sync Card error  methods

/// 取得所有同步失敗的名片，回傳 array of WCSyncErrorCardModel
- (NSArray *)copyAllSyncErrorCardWithDisplayData;

/// 取得所有同步失敗的CardIDArray
- (NSArray *)copySyncErrorCardIDArray;

/// 設定同步失敗的errorCode
- (BOOL)updateCardSyncErrorInfoWithCardID:(NSString *)cardID errorCode:(NSInteger)errorCode startSyncTime:(NSDate *)startSyncTime;

/// 清除同步失敗記錄
- (BOOL)removeCardSyncErrorInfoWithCardID:(NSString *)cardID;


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Card image SHA1 methods

/// 更新名片圖SHA1的值
- (BOOL)setImageSHA1:(NSString*)imageSHA1 withImageType:(WC_ImageType)imageType cardID:(NSString *)cardID;


/// 取得image sha1
- (NSString *)imageSha1WithCardID:(NSString *)cardID type:(WC_ImageType)type;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Convert methods 轉換用函式請集中在此

/// 轉換用函式請集中在此
//- (BOOL)convertFromXXXToXXX;

/// 1.3.0 WCGroup加入SuperGroupGuid/PinnedOrder欄位
- (BOOL)convertFrom100To130;

/// 1.4.0 加入泰文，瑞典文索引資料，產生的動作在DataController中處理
- (BOOL)convertFrom130To140;


/// 1.8.1 資料庫版號 141, 清除地址包含科學園區的聯絡人的GPS，以觸發更新GPS
- (BOOL)convertFrom140To141;



////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Advance search
/**
 * 進階搜尋，會把每一個SearchOptionModel的結果，依searchOperator做交集或聯集，最後輸出card array
 * @param advanceSearchModel 進階搜尋的條件
 * @param inFavorites 是否在我的最愛中搜尋
 * @param getAllField 是否取得所有欄位資料
 * @return array of WCCardModel, nil或[array count]==0, 表示查不到
 */
- (NSMutableArray *)copyCardWithAdvancedSearchModel:(WCTAdvancedSearchModel *)advanceSearchModel inFavorites:(BOOL)inFavorites getAllField:(BOOL)getAllField;




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - log methods
+ (NSString *)logPath;



@end
