//
//  WCRecognitionController.h
//
//  Created by Howard on 2015/7/29.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CrossPlatformDefine.h"

// Model
#import "WCRecognitionCardModel.h"
#import "WCRecogSourceModel.h"

// Controller
#import "PPIndexingController.h"

@interface WCRecognitionController : NSObject


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property 

@property (nonatomic,assign) PPIndexingStyle ppIndexStyle;

/// 是否將電話格式化
@property (nonatomic, assign) BOOL autoFormatPhone;

/// 是否將電話加上國碼，autoFormatPhone==YES時才有效
@property (nonatomic, assign) BOOL addCountryCodeToPhone;

///  取得辨識用的影像
- (CPImage *)imageFromRecogSource:(WCRecogSourceModel *)recogSource;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (BOOL)recognizeImage:(CPImage *)image
           toCardModel:(WCRecognitionCardModel *)cardModel
       withRecogSource:(WCRecogSourceModel *)recogSource
                 error:(NSError **)error;

- (BOOL)clipRecogWithRect:(CGRect)clipRect
                recogType:(uint)recogType
              recogSource:(WCRecogSourceModel *)recogSourceModel
                     card:(WCRecognitionCardModel *)cardModel
                    error:(NSError **)error __deprecated;

- (BOOL)clipRecogWithRecogSource:(WCRecogSourceModel *)recogSourceModel
                            card:(WCRecognitionCardModel *)cardModel
                           error:(NSError **)error;

- (WCRecognitionCardModel *)cardModelWithSignatureRecogSourceString:(NSString *)sourceString error:(NSError **)error;
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - class Method

/// 回傳核心版本，無法取得時會回傳@""
+ (NSString *)kernelVersion;


@end
